/*
* ============================================================================
*  Name     : CThreadAppUi from CThreadAppUi.h
*  Part of  : Thread
*  Created  : 04.02.2005 by Forum Nokia
*  Description:
*      Declares UI class for application.
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef THREAD_APPUI_H
#define THREAD_APPUI_H

// INCLUDES
#include <aknappui.h>

// FORWARD DECLARATIONS
class CThreadEngine;
class CThreadAppView;

// CLASS DECLARATION

/*!
* An instance of class CThreadAppUi is the UserInterface part of the AVKON
* application framework for the Thread example application
*/
class CThreadAppUi : public CAknAppUi
    {
public:

/*!
* ConstructL()
*  
* discussion Perform the second phase construction of a CThreadAppUi object.
* This needs to be public due to the way the framework constructs the AppUi 
*/
    void ConstructL();

/*!
* CThreadAppUi()
*  
* discussion Perform the first phase of two phase construction.
* This needs to be public due to the way the framework constructs the AppUi 
*/
    CThreadAppUi();


/*!
* ~CThreadAppUi
*  
* discussion Destroy the object
*/
    ~CThreadAppUi();


public: // from CAknAppUi
/*!
* HandleCommandL()
*  
* discussion Handle user menu selections
* param aCommand The enumerated code for the option selected
*/
    void HandleCommandL(TInt aCommand);

private:

    // The application view
    CThreadAppView* iAppView;

    // Thread engine
    CThreadEngine* iThreadEngine;
    };


#endif // __THREAD_APPUI_H__
