/*
* ============================================================================
*  Name     : CThreadAppView from CThreadAppView.h
*  Part of  : Thread
*  Created  : 04.02.2005 by Forum Nokia
*  Description:
*      Declares control for application.
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef THREAD_APPVIEW_H
#define THREAD_APPVIEW_H

// INCLUDES
#include <coecntrl.h>
#include "Richtexteditorrte.h"

// FORWARD DECLARATIONS
class CThreadAnimation;

// CLASS DECLARATION

/*!
*  CThreadAppView An instance of CThreadAppView is the Application View object
*  for the Thread example application
*/
class CThreadAppView : public CCoeControl
	{
public:

/*!
* NewL()
*   
* discussion Create a CThreadAppView object, which will draw itself to aRect
*
* param aRect The rectangle this view will be drawn to
* result A pointer to the created instance of CThreadAppView
*/
    static CThreadAppView* NewL(const TRect& aRect);

/*!
* NewLC()
*   
* discussion Create a CThreadAppView object, which will draw itself to aRect
*
* param aRect The rectangle this view will be drawn to
* result A pointer to the created instance of CThreadAppView
*/
    static CThreadAppView* NewLC(const TRect& aRect);


/*!
* ~CThreadAppView()
*  
*  discussion Destroy the object
*/
     ~CThreadAppView();

public:  // From CCoeControl
/*!
* Draw()
*  
* discussion Draw this CThreadAppView to the screen
*
* param aRect The rectangle of this view that needs updating
*/
    void Draw(const TRect& aRect) const;

public:  // Member functions

/*!
* DrawText()
*  
* discussion Draw text on the screen using a rich text editor.
*
* param aText text to be displayed.
*/
	void DrawText(const TDesC& aText);

public:  // Data members

    // Animation of thread1
    CThreadAnimation* iAnimationOne;
    // Animation of thread2
    CThreadAnimation* iAnimationTwo;
    // Animation of thread3
    CThreadAnimation* iAnimationThree;
	
private: // Basic two-phase EPOC constructors

/*!
* ConstructL()
*  
* discussion Perform the second phase construction of a CThreadAppView object
*
* param aRect The rectangle this view will be drawn to
*/
    void ConstructL(const TRect& aRect);

/*!
* CThreadAppView()
*  
* discussion Perform the first phase of two phase construction 
*/
    CThreadAppView();

private: // From CCoeControl
	
    /**
    * From CoeControl,SizeChanged.
    */
	void SizeChanged();

    /**
    * From CoeControl,CountComponentControls.
    */
	TInt CountComponentControls() const;
	
    /**
    * From CCoeControl,ComponentControl.
    */
	CCoeControl* ComponentControl(TInt aIndex) const;

private: // Data members
	
    // Rich text editor
    CRichTextEditorRTE* iRte;

    // From CoeControl
    TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
    };

#endif // THREAD_APPVIEW_H
