/*
* ============================================================================
*  Name     : CThreadDocument from CThreadDocument.h
*  Part of  : Thread
*  Created  : 04.02.2005 by Forum Nokia
*  Description:
*       Declares document for application.
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef THREAD_DOCUMENT_H
#define THREAD_DOCUMENT_H

// INCLUDES
#include <akndoc.h>

// FORWARD DECLARATIONS
class CThreadAppUi;
class CEikApplication;

// CLASS DECLARATION

/*!
* discussion An instance of class CThreadDocument is the Document part of the AVKON
* application framework for the Thread example application
*/
class CThreadDocument : public CAknDocument
    {
public:

/*!
*  NewL()
*  
*  discussion Construct a CThreadDocument for the AVKON application aApp 
*  using two phase construction, and return a pointer to the created object
*  param aApp The application creating this document
*  result A pointer to the created instance of CThreadDocument
*/
    static CThreadDocument* NewL(CEikApplication& aApp);

/*!
*  NewLC()
*  
*  discussion Construct a CThreadDocument for the AVKON application aApp 
*  using two phase construction, and return a pointer to the created object
*  param aApp The application creating this document
*  result A pointer to the created instance of CThreadDocument
*/
    static CThreadDocument* NewLC(CEikApplication& aApp);

/*!
* ~CThreadAppView()
*  
*  discussion Destroy the object
*/
    ~CThreadDocument();

public: // from CAknDocument
/*!
*  CreateAppUiL() 
*  
*  discussion Create a CThreadAppUi object and return a pointer to it
*  result A pointer to the created instance of the AppUi created
*/
    CEikAppUi* CreateAppUiL();

private: // Basic two-phase EPOC constructors

/*!
*  ConstructL()
*  
*  discussion Perform the second phase construction of a CThreadDocument object
*/
    void ConstructL();

/*!
*  CThreadDocument()
*  
*  discussion Perform the first phase of two phase construction 
*  param aApp The application creating this document
*/
    CThreadDocument(CEikApplication& aApp);
    };

#endif // THREAD_DOCUMENT_H
