/*
* ============================================================================
*  Name     : CThreadEngine from CThreadEngine.h
*  Part of  : Thread
*  Created  : 04.02.2005 by Forum Nokia
*  Description:
*     Declares thread handling operations. Intended as an example of thread
      usage and synchronization between several threads.
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

#ifndef CTHREADENGINE_H
#define CTHREADENGINE_H

// INCLUDES
#include "e32base.h" //CTimer
#include "Threadappview.h"

// CLASS DECLARATION

/**
*  CThreadEngine application engine class.
*/
class CThreadEngine : public CTimer
    {

public: 

   /*!
    * NewL()
    * 
    * Create new CThreadEngine object
    * return a pointer to the created instance of CThreadEngine
    * @param aView a Pointer to CThreadAppView. 
    */
    static CThreadEngine* NewL(CThreadAppView* aView);

   /*!
    * NewLC()
    *	 
    */
    static CThreadEngine* NewLC(CThreadAppView* aView);

   /*!
    * Destructor
    *	 
    */
    ~CThreadEngine(void);

   /*!
    * DoCancelL()
    *
    * Cancels the timer.
    */
    void DoCancel();

   /*!
    * RunL()
    *
    * Implementation of the timer's virtual method. Check that all threads are alive
    * and running, if not then restart them.
    */
    void RunL();

   /*!
    * RunError()
    *
    * Handles a leave occurring in the request completion event handler RunL().
    * return returns always KErrNone
    */
    TInt RunError(TInt aError);

   /*!
    * StartL()
    *
    * CreateThreads and start the timer after delay. 
    */
    void StartL();

   /*!
    * CreateThreadsL()
    *
    * Initialize 3 threads and start them.
    */
    void CreateThreadsL();

   /*!
    * ExecuteThreadOne();
    *
    * Function for thread one. Thread one executes this function while it's running.
    * param aPtr pointer to a resource.
    */
    static TInt ExecuteThreadOne(TAny *aPtr);

   /*!
    * ExecuteThreadTwo()
    *
    * Function for thread two. Thread two executes this function while it's running.
    * param aPtr pointer to a resource.
    */
    static TInt ExecuteThreadTwo(TAny *aPtr);

   /*!
    * ExecuteThreadThree()
    *
    * Function for thread three. Thread three executes this function while it's running.
    * param aPtr pointer to a resource.
    */
    static TInt ExecuteThreadThree(TAny *aPtr);

   /*!
    * KillThread()
    *
    * Kill one of the threads. CreateThreadsL must have been called before this.
    * param aThreadCount the number of the thread that should be killed (1-3).
    */
    void KillThread(TInt aThreadCount);

   /*!
    * SetSyncValue()
    *
    * This is a thread-safe function. Set synchronized variable.
    * param aValue Value of the variable.
    */
    void SetSyncValue(TInt aValue);

   /*!
    * GetSyncValue()
    *
    * This is a thread-safe function. 
    * return value of the synchronized variable.
    */
    TInt GetSyncValue() const;

public: //data members
    // Needed for synchronization
    RMutex iMutex;

private: // Basic two-phase EPOC constructors

   /*!
    * ConstructL()
    *
    * @param aView a Pointer to CThreadAppView. 
    */
	void ConstructL(CThreadAppView* aView);

   /*!
    * CThreadEngine()
    *
    * Default contructor.
    *
    */
    CThreadEngine(void);
	
	
private: // in-class methods

   /*!
    * ThreadKilledText()
    *
    * Print(text+number)
    * param aText the text to be printed.
    * param aCount Int value that will be printed after the text.
    */
    void ThreadKilledText(const TDesC& aText, TInt aCount);

private: // data members       
    // for printing 
    CThreadAppView* iView;
	
    // handles for threads, no need to use Open if all threads have handle connected to them.
    RThread iThreadOne;
    RThread iThreadTwo;
    RThread iThreadThree;

    // threadOne uses this to demonstrate usage of an attribute
    TInt iNotSynchonizedCounter;

    // threadOne and Two use the same variable. Synchronization is required. 
    TInt iSynchronizedCounter;

    // Threads cannot be killed before they are created. True if they have been created, 
    // false otherwise.
    TBool iCreatedThreads;
    };

#endif // CTHREADENGINE
