/*
* ============================================================================
*  Name     : CRichTextEditorRTE from CRichTextEditorRTE.h
*  Part of  : Thread
*  Created  : 04.02.2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDES
#include "RichTextEditorRTE.h"
#include <barsread.h> // TResourceReader
#include <thread.rsg> // resources
#include <eikrted.h> // CEikRichTextEditor
#include <txtrich.h> // CRichText

// Standard EPOC 2nd phase constructor
void CRichTextEditorRTE::ConstructL(const CCoeControl& aView)
	{
	TResourceReader reader;
	// Construct RichTextEditor from resource
	iCoeEnv->CreateResourceReaderLC(reader, R_RICHTEXTEDITOR_RICH_TEXT_EDITOR);
	SetContainerWindowL(aView);
	ConstructFromResourceL(reader);
	CleanupStack::PopAndDestroy(); // reader
	// Sets that the control has keyboard focus
	SetFocus(ETrue);
	}

// ----------------------------------------------------------------------------
// CRichTextEditorRTE::CRichTextEditorRTE(void) 
//
// constructor
// ----------------------------------------------------------------------------
CRichTextEditorRTE::CRichTextEditorRTE(void) 
	{
	}

// ----------------------------------------------------------------------------
// CRichTextEditorRTE::AddCarriageReturnL()
//
// Insert one line break at the end of the text.
// ----------------------------------------------------------------------------
void CRichTextEditorRTE::AddCarriageReturnL()
	{
	CRichText* richText = RichText();
	richText->InsertL(richText->DocumentLength(), CEditableText::ELineBreak);
	}

// ----------------------------------------------------------------------------
// CRichTextEditorRTE::AddTextL(const TDesC& aText)
//
// Draws text using black color.
// ----------------------------------------------------------------------------
void CRichTextEditorRTE::AddTextL(const TDesC& aText)
	{
	CRichText* text = RichText();
	TInt textSize = text->DocumentLength();

	// Interested in color
	iCharacterFormatMask.SetAttrib(EAttColor); 
	// Set it to Black
	iCharacterFormat.iFontPresentation.iTextColor = KRgbBlack; 
	text->InsertL (textSize, aText);
	// Apply formatting
	text->ApplyCharFormatL(iCharacterFormat, iCharacterFormatMask,textSize,aText.Length());
	AddCarriageReturnL();
	HandleTextChangedL();

	//Keep displaying the bottom of the screen
	MoveCursorL (TCursorPosition::EFPageDown, EFalse);
	}

CRichTextEditorRTE* CRichTextEditorRTE::NewL(const CCoeControl& aView)
	{
	CRichTextEditorRTE* self = CRichTextEditorRTE::NewLC(aView);
	CleanupStack::Pop(self);
	return self;
	}

CRichTextEditorRTE* CRichTextEditorRTE::NewLC(const CCoeControl& aView)
	{
	CRichTextEditorRTE* self = new (ELeave) CRichTextEditorRTE;
	CleanupStack::PushL(self);
	self->ConstructL(aView);
	return self;
	}

// ----------------------------------------------------------------------------
// TKeyResponse CRichTextEditorRTE::OfferKeyEventL(const TKeyEvent& aKeyEvent,
//		TEventCode aType)
//
// Called by the framework whenever a key event occurs.	Handles scrolling 
// events.
// ----------------------------------------------------------------------------
TKeyResponse CRichTextEditorRTE::OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType)
	{	
	if (aType == EEventKey)
		{
		if (aKeyEvent.iCode == EKeyDownArrow)
			{
			MoveCursorL (TCursorPosition::EFPageDown, EFalse);
			
			return EKeyWasConsumed;
			}
		else if (aKeyEvent.iCode == EKeyUpArrow)
			{
			MoveCursorL (TCursorPosition::EFPageUp, EFalse);
			
			return EKeyWasConsumed;
			}
		else
			{
			return CEikRichTextEditor::OfferKeyEventL(aKeyEvent, aType);
			}
		}
		
	return EKeyWasNotConsumed;
	}
