/*
* ============================================================================
*  Name     : CThreadAnimation from CThreadAnimation.h
*  Part of  : Thread
*  Created  : 04.02.2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDES
#include <AknBitmapAnimation.h>
#include <barsread.h> // TResourceReader
#include "ThreadAnimation.h"

// ----------------------------------------------------------------------------
//CThreadAnimation::CThreadAnimation(void)
//
// constructor
// ----------------------------------------------------------------------------
CThreadAnimation::CThreadAnimation(void): iAnimation(0), iRunning(EFalse)
	{
	}

// ----------------------------------------------------------------------------
//CThreadAnimation::~CThreadAnimation(void)
//
// destructor
// ----------------------------------------------------------------------------
CThreadAnimation::~CThreadAnimation(void)
	{
	delete iAnimation;
	}

CThreadAnimation* CThreadAnimation::NewL(TResourceReader& aReader, RWindow& aWindow)
	{
	CThreadAnimation* self = CThreadAnimation::NewLC(aReader,aWindow);
	CleanupStack::Pop(self);
	return self;
	}

CThreadAnimation* CThreadAnimation::NewLC(TResourceReader& aReader, RWindow& aWindow)
	{
	CThreadAnimation* self = new (ELeave) CThreadAnimation;
	CleanupStack::PushL(self);
	self->ConstructL(aReader, aWindow);
	return self;
	}

// Standard EPOC 2nd phase constructor
void CThreadAnimation::ConstructL(TResourceReader& aReader, RWindow& aWindow)
	{
	// Instantiate CAknBitmapAnimation
	iAnimation = CAknBitmapAnimation::NewL(); 
	// Provide animation control with animation data
	iAnimation->ConstructFromResourceL(aReader); 
	// Animation control needs a window
	iAnimation->SetContainerWindowL(aWindow); 
	}

// ----------------------------------------------------------------------------
// CThreadAnimation::StopAnimation()
//
// Stops the animation.
// ----------------------------------------------------------------------------
void CThreadAnimation::StopAnimation()
	{
	if( iAnimation )
		{
		iRunning = EFalse;
		iAnimation->CancelAnimation();
		}
	}

// ----------------------------------------------------------------------------
// CThreadAnimation::StartAnimationL()
//
// Start the animation only if it is not yet running.
// ----------------------------------------------------------------------------
void CThreadAnimation::StartAnimationL()
	{	
	// No need to start already running animation
	if ( iRunning )
		{
		return;
		}

	// Start thread animation
	iAnimation->StartAnimationL(); 
	iRunning = ETrue;
	}
