/*
* ============================================================================
*  Name     : CThreadAppUi from CThreadAppUi.h
*  Part of  : Thread
*  Created  : 04.02.2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDES
#include <avkon.hrh>
#include <aknnotewrappers.h> 

#include "Thread.pan"
#include "ThreadAppUi.h"
#include "ThreadAppView.h"
#include "Thread.hrh"
#include "ThreadEngine.h"

// ----------------------------------------------------------------------------
// CThreadAppUi::ConstructL()
//
// Standard EPOC 2nd phase constructor
// ----------------------------------------------------------------------------
void CThreadAppUi::ConstructL()
    {
    BaseConstructL(CAknAppUi::EAknEnableSkin);
    iAppView = CThreadAppView::NewL(ClientRect());
    iAppView->SetMopParent(this);
    // add view to control stack
    AddToStackL(iAppView);
	
    // create new watchdog for threads
    iThreadEngine = CThreadEngine::NewL(iAppView);
    }

// ----------------------------------------------------------------------------
// CThreadAppUi::CThreadAppUi()  
//
// constructor
// ----------------------------------------------------------------------------
CThreadAppUi::CThreadAppUi()                              
    {
    // No implementation required
    }

// ----------------------------------------------------------------------------
// CThreadAppUi::~CThreadAppUi()
//
// destructor
// ----------------------------------------------------------------------------
CThreadAppUi::~CThreadAppUi()
    {
    if ( iThreadEngine )
        {
        delete iThreadEngine;
        }

    if ( iAppView )
        {
        iEikonEnv->RemoveFromStack(iAppView);
        delete iAppView;
        }
    }

// ----------------------------------------------------------------------------
// CThreadAppUi::HandleCommandL(TInt aCommand)
//
// takes care of command handling
// ----------------------------------------------------------------------------
void CThreadAppUi::HandleCommandL(TInt aCommand)
    {
    switch(aCommand)
        {
        case EEikCmdExit:
        case EAknSoftkeyExit:
            Exit();
            break;

        case EThreadKillCommand1:
            {
            // kill thread1
            iThreadEngine->KillThread(1);
            }
            break;

        case EThreadKillCommand2:
            {
            // kill thread2
            iThreadEngine->KillThread(2);	
            }
            break;

        case EThreadKillCommand3:
            {
            // kill  thread3
            iThreadEngine->KillThread(3);
            }
            break;

        case EThreadStartCommand:
            {
            // start all threads
            iThreadEngine->StartL();
            }
            break;

        default:
            Panic(EThreadUi);
            break;
        }
    }

