/*
* ============================================================================
*  Name     : CThreadAppView from CThreadAppView.h
*  Part of  : Thread
*  Created  : 04.02.2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDES
#include <coemain.h>
#include "ThreadAppView.h"
#include "ThreadAnimation.h"
#include <barsread.h> //TResourceReader
#include <thread.rsg>

#include <w32std.h>

/// rich text editor starting position
#define KEditorPosition TPoint(0,55) 

CThreadAppView* CThreadAppView::NewL(const TRect& aRect)
    {
    CThreadAppView* self = CThreadAppView::NewLC(aRect);
    CleanupStack::Pop(self);
    return self;
    }

CThreadAppView* CThreadAppView::NewLC(const TRect& aRect)
    {
    CThreadAppView* self = new (ELeave) CThreadAppView;
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    return self;
    }

// ----------------------------------------------------------------------------
// CThreadAppView::CThreadAppView()
//
// constructor
// ----------------------------------------------------------------------------
CThreadAppView::CThreadAppView()
    {
    }

// ----------------------------------------------------------------------------
// CThreadAppView::~CThreadAppView()
//
// destructor
// ----------------------------------------------------------------------------
CThreadAppView::~CThreadAppView()
    {
    delete iRte;

    //delete all animations
    delete iAnimationOne;

    delete iAnimationTwo;

    delete iAnimationThree;
    }

// ----------------------------------------------------------------------------
// CThreadAppView::ConstructL(const TRect& aRect)
//
// Standard EPOC 2nd phase constructor
// ----------------------------------------------------------------------------
void CThreadAppView::ConstructL(const TRect& aRect)
    {
    // Create a window for this application view
    CreateWindowL();

    //instantiate rich text editor
    iRte = CRichTextEditorRTE::NewL(*this);
	
    // Set the windows size
    SetRect(aRect);
    
    // Activate the window, which makes it ready to be drawn
    ActivateL();

    //Reads an animation resource from a resource file 
    TResourceReader reader;
    iCoeEnv->CreateResourceReaderLC(reader, R_ANIMATION_THREAD_ONE_DATA);

    //create animation based on reader 
    iAnimationOne = CThreadAnimation::NewL(reader, Window());
    CleanupStack::PopAndDestroy(); //reader

    TResourceReader readerTwo;
    iCoeEnv->CreateResourceReaderLC(readerTwo, R_ANIMATION_THREAD_TWO_DATA); 
    iAnimationTwo = CThreadAnimation::NewL(readerTwo, Window());
    CleanupStack::PopAndDestroy(); //readerTwo

    TResourceReader readerThree;
    iCoeEnv->CreateResourceReaderLC(readerThree, R_ANIMATION_THREAD_THREE_DATA);
    iAnimationThree = CThreadAnimation::NewL(readerThree, Window());
    CleanupStack::PopAndDestroy(); //readerThree
    }

// ----------------------------------------------------------------------------
// CThreadAppView::DrawText(const TDesC& aText)
//
// Draw text on the screen, uses rich text editor.
// ----------------------------------------------------------------------------
void CThreadAppView::DrawText(const TDesC& aText)
    {
    iRte->AddTextL(aText);
    }

// ----------------------------------------------------------------------------
// CThreadAppView::Draw(const TRect& aRect) const
//
// Draw this application's view to the screen
// ----------------------------------------------------------------------------
void CThreadAppView::Draw(const TRect& aRect) const
    {
    // Get the standard graphics context 
    CWindowGc& gc = SystemGc();
    gc.Clear(aRect);
    }

// ----------------------------------------------------------------------------
// CThreadAppView::SizeChanged()
//
// called by framework when the view size is changed
// ----------------------------------------------------------------------------
void CThreadAppView::SizeChanged()
    {
    iRte->SetExtent(KEditorPosition, Window().Size());    
    }

// ----------------------------------------------------------------------------
// TInt CThreadAppView::CountComponentControls() const
//
// Called by the framework in compound controls	
// ----------------------------------------------------------------------------
TInt CThreadAppView::CountComponentControls() const
    {
    return 1; // return number of controls inside this container
    }

// ----------------------------------------------------------------------------
// CCoeControl* CThreadAppView::ComponentControl(TInt aIndex) const
//
// Called by the framework in compound controls	
// ----------------------------------------------------------------------------
CCoeControl* CThreadAppView::ComponentControl(TInt aIndex) const
    {
    switch (aIndex)
        {
    case 0:
        return iRte;
    default:
        return NULL;
        }
    }

// ----------------------------------------------------------------------------
// TKeyResponse CThreadAppView::OfferKeyEventL(const TKeyEvent& aKeyEvent,
//		TEventCode aType)
//
// Called by the framework whenever a key event occurs.	
// Passes the key event to the editor if it is not null, otherwise returns
// EKeyWasNotConsumed
// ----------------------------------------------------------------------------
TKeyResponse CThreadAppView::OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType)
    {
    if (iRte)
        {
        return iRte->OfferKeyEventL(aKeyEvent, aType);
        }
    else 
        {
        return CCoeControl::OfferKeyEventL(aKeyEvent, aType);
        }
    }
