/*
* ============================================================================
*  Name     : CThreadDocument from CThreadDocument.h
*  Part of  : Thread
*  Created  : 04.02.2005 by Forum Nokia
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

// INCLUDES
#include "ThreadAppUi.h"
#include "ThreadDocument.h"

CThreadDocument* CThreadDocument::NewL(CEikApplication& aApp)
    {
    CThreadDocument* self = NewLC(aApp);
    CleanupStack::Pop(self);
    return self;
    }

CThreadDocument* CThreadDocument::NewLC(CEikApplication& aApp)
    {
    CThreadDocument* self = new (ELeave) CThreadDocument(aApp);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }

// ----------------------------------------------------------------------------
// CThreadDocument::ConstructL()
//
// Standard EPOC 2nd phase constructor
// ----------------------------------------------------------------------------
void CThreadDocument::ConstructL()
    {
    // No implementation required
    }    

// ----------------------------------------------------------------------------
// CThreadDocument::CThreadDocument(CEikApplication& aApp) 
//   
// constructor
// ----------------------------------------------------------------------------
CThreadDocument::CThreadDocument(CEikApplication& aApp) : CAknDocument(aApp) 
    {
    }

// ----------------------------------------------------------------------------
// CThreadDocument::~CThreadDocument()
//   
// destructor
// ----------------------------------------------------------------------------
CThreadDocument::~CThreadDocument()
    {
    }

// ----------------------------------------------------------------------------
// CThreadDocument::CreateAppUiL()
//
// constructs CThreadAppUi
// ----------------------------------------------------------------------------
CEikAppUi* CThreadDocument::CreateAppUiL()
    {
    // Create the application user interface, and return a pointer to it;
    // the framework takes ownership of this object
    return (static_cast <CEikAppUi*> (new (ELeave) CThreadAppUi)); 
    }
