// SymbianOSBasicsLab.cpp
//
// Copyright (c) 2003 Nokia Ltd.  All rights reserved.


#include <e32cons.h>

// Function prototype
LOCAL_C void UseBasicTypesL();

//////////////////////////////////////////////////////////////////////////////
//
// Main function called by E32
//
//////////////////////////////////////////////////////////////////////////////
GLDEF_C TInt E32Main()
    {

    // Catch any Leaves thrown 
    TRAPD(error, UseBasicTypesL());

	_LIT(KMsgPanic,"Error in Symbian OS Basics Lab: ");
	__ASSERT_ALWAYS(!error, User::Panic(KMsgPanic, error));

	return 0;
    }


//////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////
LOCAL_C void UseBasicTypesL() 
    {
    // Constant text used for the console app title 
	_LIT(KLabTitle,"Symbian OS Basics Lab");
    
    //
    // 'C' class usage:
    //
    // CConsoleBase derives from CBase and so should be declared on the heap
    // Console::NewL is a special way of doing this we will cover in the 
    // Memory and Resource Management lesson
    CConsoleBase* console = Console::NewL(KLabTitle, TSize(KConsFullScreen, KConsFullScreen));

    //
    // TInt usage
    //
    const TInt KOne = 1;
    const TInt KTwo = 2;

    // Edit 1: On the line below, declare a TInt called <sum> that adds KOne and KTwo


    _LIT(KSumOutput, "%d + %d is %d\n");
    // Edit 2: Uncomment the next line that prints the variables to the screen
    // console->Printf(KSumOutput, KOne, KTwo, sum);

    _LIT(KMaxIntOutput, "TInt max: %d\n");
    console->Printf(KMaxIntOutput, KMaxTInt);

    _LIT(KMinIntOutput, "TInt min: %d\n");
    console->Printf(KMinIntOutput, KMinTInt);

    //
    // TBool usage
    //

    // Edit 3: Declare a TBool called <flag> and initialize to EFalse


    // Edit 4: Uncomment the next 5 lines
    // if (!flag)
    //     {
    //     _LIT(KFlagFalse, "flag is EFalse\n");
    //     console->Printf(KFlagFalse);
    //     }

    // Edit 5: Toggle the value of <flag>


    // Edit 6: Uncomment the next 5 lines    
    // if (flag)
    //     {
    //     _LIT(KFlagTrue, "flag is ETrue\n");
    //     console->Printf(KFlagTrue);
    //     }

    //
    // enum (TKeyCode) and TText usage
    //
    _LIT(KEnterSpace, "Press space to start timer\n");
    console->Printf(KEnterSpace);

    // Look at key input
    TKeyCode key = console->Getch();
    while (EKeySpace != key)
        {
        _LIT(KCharVal, "Char entered is '%c'\n");

        // Edit 7: Delcare a TText called <keyVal> and set it to <key>.
        


        // Edit 8: Uncomment the next line
        // console->Printf(KCharVal, keyVal);
        key = console->Getch();
        }

    //
    // 'R' class usage
    //
    RTimer timer;
    if (KErrNone == timer.CreateLocal())
        {
        TRequestStatus status; // tracks the status of the request
        const TTimeIntervalMicroSeconds32 KTimerInterval = 5000000;
    
        // Edit 9: Uncomment next line to request timeout of 
        //          KTimerInterval micro seconds
        // timer.After(status, KTimerInterval); 

        // Edit 10: Uncomment next line to wait synchronously 
        //          for the timer to complete.
        // User::WaitForRequest(status);

        // Edit 11: Uncomment the next 2 lines that print to the screen
        // _LIT(KTimerComplete, "Timer completed after %d micro secs\n");
        // console->Printf(KTimerComplete, KTimerInterval );
        }
    else
        {
        _LIT(KTimerError, "Error creating timer\n");
        console->Printf(KTimerError);
        }

    timer.Close();

    // Continue
	_LIT(KMsgPressAnyKey,"Press any key to end");
	console->Printf(KMsgPressAnyKey);
	console->Getch();
    
    delete console;
    }




