// Copyright: (c) 2006 Nokia Ltd.  All rights reserved.

#ifndef __S60MemoryLabApplication_H__
#define __S60MemoryLabApplication_H__

// INCLUDES
#include <aknapp.h>

// CLASS DECLARATION

/**
* CS60MemoryLabApplication application class.
* Provides factory to create concrete document object.
* An instance of CS60MemoryLabApplication is the application part of the
* AVKON application framework for the S60MemoryLab example application.
*/
class CS60MemoryLabApplication : public CAknApplication
    {
    public: // Functions from base classes

        /**
        * From CApaApplication, AppDllUid.
        * @return Application's UID (KUidS60MemoryLabApp).
        */
        TUid AppDllUid() const;

    protected: // Functions from base classes

        /**
        * From CApaApplication, CreateDocumentL.
        * Creates CS60MemoryLabDocument document object. The returned
        * pointer in not owned by the CS60MemoryLabApplication object.
        * @return A pointer to the created document object.
        */
        CApaDocument* CreateDocumentL();
    };

#endif // __S60MemoryLabApplication_H__

// End of File
