// Copyright: (c) 2006 Nokia Ltd.  All rights reserved.

// INCLUDE FILES
#include "S60MemoryLabAppUi.h"
#include "S60MemoryLabContainer.h" 
#include <S60MemoryLab.rsg>
#include "s60memorylab.hrh"

#include <avkon.hrh>

// ================= MEMBER FUNCTIONS =======================
//
// ----------------------------------------------------------
// CS60MemoryLabAppUi::ConstructL()
// ?implementation_description
// ----------------------------------------------------------
//
void CS60MemoryLabAppUi::ConstructL()
    {
    BaseConstructL();
    iAppContainer = new (ELeave) CS60MemoryLabContainer;
    iAppContainer->SetMopParent(this);
    iAppContainer->ConstructL( ClientRect() );
    AddToStackL( iAppContainer );
    }

// ----------------------------------------------------
// CS60MemoryLabAppUi::~CS60MemoryLabAppUi()
// Destructor
// Frees reserved resources
// ----------------------------------------------------
//
CS60MemoryLabAppUi::~CS60MemoryLabAppUi()
    {
    if (iAppContainer)
        {
        RemoveFromStack( iAppContainer );
        delete iAppContainer;
        }
   }

// ------------------------------------------------------------------------------
// CS60MemoryLabAppUi::::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
// ------------------------------------------------------------------------------
//
void CS60MemoryLabAppUi::DynInitMenuPaneL(
    TInt /*aResourceId*/,CEikMenuPane* /*aMenuPane*/)
    {
    }

// ----------------------------------------------------
// CS60MemoryLabAppUi::HandleKeyEventL(
//     const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
// ?implementation_description
// ----------------------------------------------------
//
TKeyResponse CS60MemoryLabAppUi::HandleKeyEventL(
    const TKeyEvent& /*aKeyEvent*/,TEventCode /*aType*/)
    {
    return EKeyWasNotConsumed;
    }

// ----------------------------------------------------
// CS60MemoryLabAppUi::HandleCommandL(TInt aCommand)
// ?implementation_description
// ----------------------------------------------------
//
void CS60MemoryLabAppUi::HandleCommandL(TInt aCommand)
    {
    switch ( aCommand )
        {
        case EAknSoftkeyBack:
        case EEikCmdExit:
            Exit();
            break;

        case ES60MemoryLabCmdToggleLabels:
            iAppContainer->ToggleLabelsL();
            break;

        case ES60MemoryLabCmdCleanupStackTest:
            iAppContainer->CleanupStackTestL();
            break;

        default:
            break;      
        }
    }

// -----------------------------------------------------------------------------
// CS60MemoryLabAppUi::HandleScreenDeviceChangedL
// Handle change in screen resolution.
// -----------------------------------------------------------------------------
//
void CS60MemoryLabAppUi::HandleScreenDeviceChangedL()
    {
    CAknAppUi::HandleScreenDeviceChangedL();

    // Reposition the container
    if ( iAppContainer )
        {
        iAppContainer->SetRect(ClientRect());
        }
    }
    
// End of File  
