// Copyright: (c) 2006 Nokia Ltd.  All rights reserved.

#ifndef __S60MemoryLabDocument_h__
#define __S60MemoryLabDocument_h__

// INCLUDES
#include <akndoc.h>

// FORWARD DECLARATIONS
class CS60MemoryLabAppUi;
class CEikApplication;


// CLASS DECLARATION

/**
* CS60MemoryLabDocument application class.
* An instance of class CS60MemoryLabDocument is the Document part of the
* AVKON application framework for the S60MemoryLab example application.
*/
class CS60MemoryLabDocument : public CAknDocument
    {
    public: // Constructors and destructor

        /**
        * NewL.
        * Two-phased constructor.
        * Construct a CS60MemoryLabDocument for the AVKON application aApp
        * using two phase construction, and return a pointer
        * to the created object.
        * @param aApp Application creating this document.
        * @return A pointer to the created instance of CS60MemoryLabDocument.
        */
        static CS60MemoryLabDocument* NewL( CEikApplication& aApp );

        /**
        * NewLC.
        * Two-phased constructor.
        * Construct a CS60MemoryLabDocument for the AVKON application aApp
        * using two phase construction, and return a pointer
        * to the created object.
        * @param aApp Application creating this document.
        * @return A pointer to the created instance of CS60MemoryLabDocument.
        */
        static CS60MemoryLabDocument* NewLC( CEikApplication& aApp );

        /**
        * ~CS60MemoryLabDocument
        * Virtual Destructor.
        */
        virtual ~CS60MemoryLabDocument();

    public: // Functions from base classes

        /**
        * CreateAppUiL
        * From CEikDocument, CreateAppUiL.
        * Create a CS60MemoryLabAppUi object and return a pointer to it.
        * The object returned is owned by the Uikon framework.
        * @return Pointer to created instance of AppUi.
        */
        CEikAppUi* CreateAppUiL();

    private: // Constructors

        /**
        * ConstructL
        * 2nd phase constructor.
        */
        void ConstructL();

        /**
        * CS60MemoryLabDocument.
        * C++ default constructor.
        * @param aApp Application creating this document.
        */
        CS60MemoryLabDocument( CEikApplication& aApp );
    };

#endif // __S60MemoryLabDocument_h__

// End of File
