// Copyright: (c) 2006 Nokia Ltd.  All rights reserved.

// INCLUDE FILES
#include "S60MemoryLabDocument.h"
#include "S60MemoryLabApplication.h"

// ============================ MEMBER FUNCTIONS ===============================

// UID for the application;
// this should correspond to the uid defined in the mmp file
const TUid KUidS60MemoryLabApp = { 0x101F8BEE };

// -----------------------------------------------------------------------------
// CS60MemoryLabApplication::CreateDocumentL()
// Creates CApaDocument object
// -----------------------------------------------------------------------------
//
CApaDocument* CS60MemoryLabApplication::CreateDocumentL()
    {
    // Create an S60MemoryLab document, and return a pointer to it
    return (static_cast<CApaDocument*>
                    ( CS60MemoryLabDocument::NewL( *this ) ) );
    }

// -----------------------------------------------------------------------------
// CS60MemoryLabApplication::AppDllUid()
// Returns application UID
// -----------------------------------------------------------------------------
//
TUid CS60MemoryLabApplication::AppDllUid() const
    {
    // Return the UID for the S60MemoryLab application
    return KUidS60MemoryLabApp;
    }

// End of File
