// Copyright: (c) 2006 Nokia Ltd.  All rights reserved.

// INCLUDE FILES
#include "S60MemoryLabContainer.h"
#include <eiklabel.h>  // for example label control
#include <eikappui.h>

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CS60MemoryLabContainer::ConstructL(const TRect& aRect)
// Second phase constructor
// ---------------------------------------------------------
//
_LIT(KTextExtremelyLongLabel,    "Extremely Long Label");
_LIT(KTextVeryLongLabel,         "Very Long Label");
_LIT(KTextLongLabel,             "Long Label");
_LIT(KTextLabel,                 "Label");
_LIT(KTextCleanupStackTest,      "Cleanup Stack Test");


void CS60MemoryLabContainer::ConstructL(const TRect& aRect)
    {
    CreateWindowL();

    // Edit 1: uncomment the line below 
    // User::Leave(KErrCancel);

    iTopLabel = new (ELeave) CEikLabel;
    iTopLabel->SetContainerWindowL(*this);
    iTopLabel->SetTextL(KTextLabel);

    iBottomLabel = new (ELeave) CEikLabel;
    iBottomLabel->SetContainerWindowL( *this );
    iBottomLabel->SetTextL(KTextLongLabel);

    SetRect(aRect);
    ActivateL();
    }

// Destructor
CS60MemoryLabContainer::~CS60MemoryLabContainer()
    {
    delete iTopLabel;
    delete iBottomLabel;
    }

void CS60MemoryLabContainer::ToggleLabelsL()
    {
    if (iToggleFlag)
        {
        iTopLabel->SetTextL(KTextLabel);
        iBottomLabel->SetTextL(KTextLongLabel);
        }
    else
        {
        // Edit 3: 
        //  a) Add a Trap harness (TRAPD macro) around the following 3 lines of code
        //  b) If an error occurs:
        //      i) Set the text of iTopLabel to be KTextLabel
        //      ii) Raise the error again using User::Leave(error)
        iTopLabel->SetTextL(KTextVeryLongLabel);
        // Edit 2: Uncomment the line below
        // User::Leave(KErrNoMemory); // simulates the line below leaving
        iBottomLabel->SetTextL(KTextExtremelyLongLabel);
        }
    iToggleFlag = !iToggleFlag;
    }

void CS60MemoryLabContainer::CleanupStackTestL()
    {
    // Create string on the heap to store a copy of a literal string
    HBufC* labelText = HBufC::NewL(KTextCleanupStackTest().Length());   
    // Edit 5: Put labelText on the Cleanup Stack using 
    //         CleanupStack::PushL(labelText);
    //         Alternatively HBufC::NewLC(KTextCleanupStackTest().Length()) could 
    //         be called instead of HBufC::NewL(KTextCleanupStackTest().Length())
    *labelText = KTextCleanupStackTest; // Initialise the heap string
    // Edit 4: Uncomment the line below
    // User::Leave(KErrNoMemory); // mimic the effect of SetTextL() below leaving
    iBottomLabel->SetTextL(*labelText);
    // Edit 6: Replace the following line with CleanupStack::PopAndDestroy();
    delete labelText;
    }


// ---------------------------------------------------------
// CS60MemoryLabContainer::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void CS60MemoryLabContainer::SizeChanged()
    {
    // Set the position and size of the labels so they can 
    // hold all the text
    TRect rect = Rect();
    
    iTopLabel->SetExtent( TPoint(0,0), TSize(Rect().Width(), Rect().Height()/2));
    iBottomLabel->SetExtent( TPoint(0,Rect().Height()/2), TSize(Rect().Width(),Rect().Height()/2));
    }

// ---------------------------------------------------------
// CS60MemoryLabContainer::CountComponentControls() const
// ---------------------------------------------------------
//
TInt CS60MemoryLabContainer::CountComponentControls() const
    {
    return 2; // return nbr of controls inside this container
    }

// ---------------------------------------------------------
// CS60MemoryLabContainer::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* CS60MemoryLabContainer::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            return iTopLabel;
        case 1:
            return iBottomLabel;
        default:
            return NULL;
        }
    }

// ---------------------------------------------------------
// CS60MemoryLabContainer::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void CS60MemoryLabContainer::Draw(const TRect& aRect) const
    {
    CWindowGc& gc = SystemGc();

    gc.SetPenStyle(CGraphicsContext::ENullPen);
    gc.SetBrushColor(KRgbGray);
    gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
    gc.DrawRect(aRect);
    }

// ---------------------------------------------------------
// CS60MemoryLabContainer::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void CS60MemoryLabContainer::HandleControlEventL(
    CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
    {
    // Do nothing
    }
    
// End of File  
