// Copyright: (c) 2006 Nokia Ltd.  All rights reserved.

// INCLUDE FILES
#include "S60MemoryLabAppUi.h"
#include "S60MemoryLabDocument.h"

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CS60MemoryLabDocument::NewL()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CS60MemoryLabDocument* CS60MemoryLabDocument::NewL(CEikApplication& aApp)
    {
    CS60MemoryLabDocument* self = NewLC( aApp );
    CleanupStack::Pop( self );
    return self;
    }

// -----------------------------------------------------------------------------
// CS60MemoryLabDocument::NewLC()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CS60MemoryLabDocument* CS60MemoryLabDocument::NewLC(CEikApplication& aApp)
    {
    CS60MemoryLabDocument* self = new (ELeave) CS60MemoryLabDocument(aApp);
    CleanupStack::PushL( self );
    self->ConstructL();
    
    return self;
    }

// -----------------------------------------------------------------------------
// CS60MemoryLabDocument::ConstructL()
// Symbian 2nd phase constructor can leave.
// -----------------------------------------------------------------------------
//
void CS60MemoryLabDocument::ConstructL()
    {
    // No implementation required
    }

// -----------------------------------------------------------------------------
// CS60MemoryLabDocument::CS60MemoryLabDocument()
// C++ default constructor can NOT contain any code, that might leave.
// -----------------------------------------------------------------------------
//
CS60MemoryLabDocument::CS60MemoryLabDocument( CEikApplication& aApp )
    : CAknDocument( aApp )
    {
    // No implementation required
    }

// ---------------------------------------------------------------------------
// CS60MemoryLabDocument::~CS60MemoryLabDocument()
// Destructor.
// ---------------------------------------------------------------------------
//
CS60MemoryLabDocument::~CS60MemoryLabDocument()
    {
    // No implementation required
    }

// ---------------------------------------------------------------------------
// CS60MemoryLabDocument::CreateAppUiL()
// Constructs CreateAppUi.
// ---------------------------------------------------------------------------
//
CEikAppUi* CS60MemoryLabDocument::CreateAppUiL()
    {
    // Create the application user interface, and return a pointer to it;
    // the framework takes ownership of this object
    return (static_cast <CEikAppUi*>(new (ELeave) CS60MemoryLabAppUi));
    }

// End of File
