// Copyright: (c) 2006 Nokia Ltd.  All rights reserved.

#ifndef _DESCRIPTOR_LAB_
#define _DESCRIPTOR_LAB_
// CLASS DECLARATION

/**
* CDescriptorLab class.
* Implements all descriptor usage for the lab
* 
*/
class CDescriptorLab : public CBase
    {
public: // construction / destruction
    /**
    * Two-phased constructor.
    */
    static CDescriptorLab* NewLC();

    /**
    * Destructor.
    */
    ~CDescriptorLab();

public: // new functions
    /**
    *  Run the descriptor lab
    */
    void StartL();

private: // construction
    /**
    * Default C++ constructor.
    */
    CDescriptorLab();

    /**
    * 2nd phase constructor.
    */
    void ConstructL();

private: // new functions
    /**
    * Declare and use a buffer descriptor
    */
    void UseBufferDes();

    /**
    * Declare and use a heap descriptor
    */
    void UseHeapDesL();

    /**
    * Gets a string entered by the user up to the
    * maximum length of the descriptor passed in
    */
    void GetStringFromUser(TDes& aBuf);

    /**
    * Returns an HBufC* containing a string entered 
    * by the user of no maximum length.
    * NB. The caller is responsible for deleting the HBufC* 
    */
    HBufC* StringFromUserL();

    /**
    * Returns the character entered by the user
    */
    TText CharFromUser();

    /**
    * Gets a char from the user. Prints to the screen
    * the number of occurances of that char in the 
    * descriptor passed into the function.
    */
    void CharOccurance(TDesC& aSearchStr);

private: // data
    CConsoleBase* iConsole; // Console window
    };

#endif // _DESCRIPTOR_LAB_