// Copyright: (c) 2006 Nokia Ltd.  All rights reserved.

#include <e32cons.h>
#include "descriptorlab.h"


//////////////////////////////////////////////////////////////////////////////
//
// Main function called by E32
//
//////////////////////////////////////////////////////////////////////////////
GLDEF_C TInt E32Main()
    {
	CTrapCleanup* cleanup=CTrapCleanup::New();

    // Catch any Leaves thrown 
    TRAPD(
        error, 
        CDescriptorLab* lab = CDescriptorLab::NewLC();
        lab->StartL();
        CleanupStack::PopAndDestroy();
        );

	_LIT(KMsgPanic,"Error in Descriptor Lab: ");
	__ASSERT_ALWAYS(!error, User::Panic(KMsgPanic, error));

    delete cleanup;
	return 0;
    }




// ---------------------------------------------------------
// CDescriptorLab::NewLC()
// Two-phase constructor
// ---------------------------------------------------------
//
CDescriptorLab* CDescriptorLab::NewLC()
    {
    CDescriptorLab* self = new (ELeave) CDescriptorLab;
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }

// ---------------------------------------------------------
// CDescriptorLab::~CDescriptorLab()
// Destructor
// ---------------------------------------------------------
//
CDescriptorLab::~CDescriptorLab()
    {
    delete iConsole;
    }


// ---------------------------------------------------------
// CDescriptorLab::CDescriptorLab()
// Default C++ constructor
// ---------------------------------------------------------
//
CDescriptorLab::CDescriptorLab()
    {
    }

// ---------------------------------------------------------
// CDescriptorLab::ConstructL()
// Second-phase constructor
// ---------------------------------------------------------
//
void CDescriptorLab::ConstructL()
    {
    _LIT(KLabTitle,"Descriptors Lab");
    iConsole = Console::NewL(KLabTitle, TSize(KConsFullScreen, KConsFullScreen));
    }

// ---------------------------------------------------------
// CDescriptorLab::StartL()
// ---------------------------------------------------------
//
void CDescriptorLab::StartL() 
    {
    UseBufferDes();
    UseHeapDesL();
    // Continue
	_LIT(KMsgPressAnyKey,"Press any key to end");
	iConsole->Printf(KMsgPressAnyKey);
	iConsole->Getch();
    
    }

// ---------------------------------------------------------
// CDescriptorLab::UseBufferDes()
// ---------------------------------------------------------
//
void CDescriptorLab::UseBufferDes()
    {
    // Edit 1: Uncomment the following line to declare a literal string 
    // _LIT(KBufferTitle, "BUF DESCRIPTOR EG:\n");
    iConsole->Printf(KBufferTitle);

    const TInt KBufSize = 12;
    
    _LIT(KEnterString, "Enter upto %d chars. Finish with space:\n");
    iConsole->Printf(KEnterString, KBufSize);

    // Look at key input
    // Edit 2: Declare a TBuf named buf of max size KBufSize.  
    //          Initialise the length of the buffer to 0
    

    // Edit 3: Uncomment the following 2 lines of code to get a string 
    // of upto KBufSize characters from the user.  A character is then 
    // got from the user and the number of occurances of that character 
    // in the string buf printed to the screen.
    // GetStringFromUser(buf);
    // CharOccurance(buf);
    }


// ---------------------------------------------------------
// CDescriptorLab::UseHeapDesL()
// ---------------------------------------------------------
//
void CDescriptorLab::UseHeapDesL()
    {
    _LIT(KHeapTitle, "\nHEAP DESCRIPTOR EG:\n");
    iConsole->Printf(KHeapTitle);
    _LIT(KEnterString, "Enter as many chars as you wish.\nFinish with space:\n");
    iConsole->Printf(KEnterString);
    // Edit 9: Declare a HBufC* called buf that is initialised to the return 
    //          value of a call to HBufC* CDescriptorLab::StringFromUserL()

    // Edit 10: Call CDescriptorLab::CharOccurance() passing the dereferenced 
    //          value of buf

    // Edit 11: delete the memory associated with buf

    }

// ---------------------------------------------------------
// CDescriptorLab::GetStringFromUser(TDes& aBuf)
// ---------------------------------------------------------
//
void CDescriptorLab::GetStringFromUser(TDes& aBuf)
    {
    // Get a character from the user
    TText key = CharFromUser();

    // Edit 4: Declare a TInt maxLen that is initialised  
    // to the maximum length of the descriptor parameter.
    // Hint: use aBuf.MaxLength()


    while (key != EKeySpace &&  aBuf.Length() < maxLen)
        {
        // Edit 5: Append the user entered character onto the end 
        // of the descriptor passed in as a parameter
        // Hint: Use aBuf.Append(key)

        _LIT(KCharEntered, "%c");
        iConsole->Printf(KCharEntered, key);
        key = CharFromUser();
        }
    }

// ---------------------------------------------------------
// CDescriptorLab::StringFromUserL()
// ---------------------------------------------------------
//
HBufC* CDescriptorLab::StringFromUserL()
    {
    const TInt KGranularity = 10;
    // Edit 12: Declare a HBufC* called heapBuf and construct 
    //          via HBufC::NewL(KGranularity) 


    // Edit 13: Declare a TPtr called ptr that is initialised to heapBuf->Des()

    TText key = CharFromUser();
    while (key != EKeySpace)
        {
        if (ptr.Length() == ptr.MaxLength())
            {
            TInt newLen = ptr.MaxLength() + KGranularity;
            // Edit 14: Uncomment the line below to increase the maxlength of 
            //          heapBuf and retain the existing contents and length
            // heapBuf = heapBuf->ReAllocL(newLen);

            // Edit 15: Reset ptr to point to the new location of heapBuf
            //          Hint: call ptr.Set(heapBuf->Des()) rather than
            //          ptr = heapBuf->Des() as the latter will cause a panic

            }
        ptr.Append(key);
        _LIT(KCharEntered, "%c");
        iConsole->Printf(KCharEntered, key);
        key = CharFromUser();
        }
    return heapBuf;
    }

// ---------------------------------------------------------
// CDescriptorLab::CharFromUser()
// ---------------------------------------------------------
//
TText CDescriptorLab::CharFromUser()
    {
    TKeyCode key = iConsole->Getch();
    TText ret = static_cast<TText>(key);
    return ret;
    }


// ---------------------------------------------------------
// CDescriptorLab::CharOccurance(TDesC& aSearchStr)
// ---------------------------------------------------------
//
void CDescriptorLab::CharOccurance(TDesC& aSearchStr)
    {
    _LIT(KEnterChar, "\nEnter search char:");
    iConsole->Printf(KEnterChar);

    TText key = CharFromUser();
    _LIT(KCharEntered, "%c");
    iConsole->Printf(KCharEntered, key);

    TInt numChars = 0;
    // Edit 6: Declare a TPtrC called subStr and initialise it to 
    //          the aSearchStr parameter


    // Edit 7: Uncomment the line of code below to find the position of the 
    //          first occurence of the char entered by the user in aSearchString
    // TInt pos = subStr.Locate(key);
    while (KErrNotFound != pos)
        {
        numChars++;
        // Edit 8: Uncomment the line of code below to reset subStr to point to the 
        //          remainder of aSearchStr after the position of the last found char
        // subStr.Set(subStr.Mid(pos + 1));
        pos = subStr.Locate(key);
        }
    _LIT(KNumChars, "\nNumber of '%c's in\n\"%S\" = %d\n");
    iConsole->Printf(KNumChars, key, &aSearchStr, numChars);
    }



