// Copyright (c) 2006 Nokia Corporation.

#ifndef __S60RESOURCELABAPPLICATION_H__
#define __S60RESOURCELABAPPLICATION_H__

// INCLUDES
#include <aknapp.h>

// CLASS DECLARATION

/**
* CS60ResourceLabApp application class.
* Provides factory to create concrete document object.
* An instance of CS60ResourceLabApp is the application part of the
* AVKON application framework for the S60ResourceLab example application.
*/
class CS60ResourceLabApp : public CAknApplication
    {
    public: // Functions from base classes

        /**
        * From CApaApplication, AppDllUid.
        * @return Application's UID (KUidS60ResourceLabApp).
        */
        TUid AppDllUid() const;

    protected: // Functions from base classes

        /**
        * From CApaApplication, CreateDocumentL.
        * Creates CS60ResourceLabDocument document object. The returned
        * pointer in not owned by the CS60ResourceLabApp object.
        * @return A pointer to the created document object.
        */
        CApaDocument* CreateDocumentL();
    };

#endif // __S60RESOURCELABAPPLICATION_H__

// End of File
