// Copyright (c) 2006 Nokia Corporation.

// INCLUDE FILES
#include "S60ResourceLabAppUi.h"
#include "S60ResourceLabContainer.h" 
#include <S60ResourceLab.rsg>
#include "S60Resourcelab.hrh"

#include <avkon.hrh>

// ================= MEMBER FUNCTIONS =======================
//
// ----------------------------------------------------------
// CS60ResourceLabAppUi::ConstructL()
// ?implementation_description
// ----------------------------------------------------------
//
void CS60ResourceLabAppUi::ConstructL()
    {
    BaseConstructL();
    iAppContainer = new (ELeave) CS60ResourceLabContainer;
    iAppContainer->SetMopParent(this);
    iAppContainer->ConstructL( ClientRect() );
    AddToStackL( iAppContainer );
    }

// ----------------------------------------------------
// CS60ResourceLabAppUi::~CS60ResourceLabAppUi()
// Destructor
// Frees reserved resources
// ----------------------------------------------------
//
CS60ResourceLabAppUi::~CS60ResourceLabAppUi()
    {
    if (iAppContainer)
        {
        RemoveFromStack( iAppContainer );
        delete iAppContainer;
        }
    }


// ------------------------------------------------------------------------------
// CS60ResourceLabAppUi::::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
// ------------------------------------------------------------------------------
//
void CS60ResourceLabAppUi::DynInitMenuPaneL(
    TInt /*aResourceId*/,CEikMenuPane* /*aMenuPane*/)
    {
    }

// ----------------------------------------------------
// CS60ResourceLabAppUi::HandleKeyEventL(
//     const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
// ?implementation_description
// ----------------------------------------------------
//
TKeyResponse CS60ResourceLabAppUi::HandleKeyEventL(
    const TKeyEvent& /*aKeyEvent*/,TEventCode /*aType*/)
    {
    return EKeyWasNotConsumed;
    }

// ----------------------------------------------------
// CS60ResourceLabAppUi::HandleCommandL(TInt aCommand)
// ?implementation_description
// ----------------------------------------------------
//
void CS60ResourceLabAppUi::HandleCommandL(TInt aCommand)
    {
    switch ( aCommand )
        {
        case EAknSoftkeyBack:
        case EEikCmdExit:
            {
            Exit();
            break;
            }
            
        case ES60ResourceLabCmdAppTest:
            {
            HBufC* helloworld = iCoeEnv->AllocReadResourceL(R_S60RESOURCELAB_TEXT_HELLO_WORLD);
            iEikonEnv->InfoMsg(*helloworld);
            delete helloworld;
            break;
            }
       
        case ES60ResourceLabCmdGoodbye:
            {
            iAppContainer->GoodbyeL();
            break;
            }
       
        default:
            break;      
        }
    }

// End of File  
