// Copyright (c) 2006 Nokia Corporation.

// INCLUDE FILES
#include "S60ResourceLabDocument.h"
#include "S60ResourceLabApplication.h"

// ============================ MEMBER FUNCTIONS ===============================

// UID for the application;
// this should correspond to the uid defined in the mmp file
const TUid KUidS60ResourceLabApp = { 0x0D812E3F };

// -----------------------------------------------------------------------------
// CS60ResourceLabApp::CreateDocumentL()
// Creates CApaDocument object
// -----------------------------------------------------------------------------
//
CApaDocument* CS60ResourceLabApp::CreateDocumentL()
    {
    // Create an S60ResourceLab document, and return a pointer to it
    return (static_cast<CApaDocument*>
                    ( CS60ResourceLabDocument::NewL( *this ) ) );
    }

// -----------------------------------------------------------------------------
// CS60ResourceLabApp::AppDllUid()
// Returns application UID
// -----------------------------------------------------------------------------
//
TUid CS60ResourceLabApp::AppDllUid() const
    {
    // Return the UID for the S60ResourceLab application
    return KUidS60ResourceLabApp;
    }

// End of File
