// Copyright (c) 2006 Nokia Corporation.

// INCLUDE FILES
#include "S60ResourceLabContainer.h"
#include <S60ResourceLab.rsg>

#include <eiklabel.h>  // for example label control
#include <coemain.h>   // for CCoeEnv

// ================= MEMBER FUNCTIONS =======================

_LIT(KTextHello, "Hello");
_LIT(KTextWorld, "World!");
// ---------------------------------------------------------
// CS60ResourceLabContainer::ConstructL(const TRect& aRect)
// EPOC two phased constructor
// ---------------------------------------------------------
//
void CS60ResourceLabContainer::ConstructL(const TRect& aRect)
    {
    CreateWindowL();

    iLabel = new (ELeave) CEikLabel;
    iLabel->SetContainerWindowL( *this );
    iLabel->SetTextL(KTextHello);

    iToDoLabel = new (ELeave) CEikLabel;
    iToDoLabel->SetContainerWindowL( *this );
    iToDoLabel->SetTextL(KTextWorld);

    SetRect(aRect);
    ActivateL();
    }

// Destructor
CS60ResourceLabContainer::~CS60ResourceLabContainer()
    {
    delete iLabel;
    delete iToDoLabel;
    }

void CS60ResourceLabContainer::GoodbyeL()
    {
    HBufC* goodbye = iCoeEnv->AllocReadResourceLC(R_S60RESOURCELAB_TEXT_GOODBYE);
    iLabel->SetTextL(*goodbye);
    HBufC* everyone = iCoeEnv->AllocReadResourceLC(R_S60RESOURCELAB_TEXT_EVERYONE);
    iToDoLabel->SetTextL(*everyone);
    CleanupStack::PopAndDestroy(2);
    }

// ---------------------------------------------------------
// CS60ResourceLabContainer::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void CS60ResourceLabContainer::SizeChanged()
    {
    // Set the postion of the labels and reserve 
    // a minimum size for expansion
    //iLabel->SetExtent(TPoint(60, 50), TSize(100, 15));
    //iToDoLabel->SetExtent(TPoint(60, 80), TSize(100, 15));
    iLabel->SetExtent( TPoint(0,0), TSize(Rect().Width(), Rect().Height()/2));
    iToDoLabel->SetExtent( TPoint(0,Rect().Height()/2), TSize(Rect().Width(),Rect().Height()/2));
    }

// ---------------------------------------------------------
// CS60ResourceLabContainer::CountComponentControls() const
// ---------------------------------------------------------
//
TInt CS60ResourceLabContainer::CountComponentControls() const
    {
    return 2; // return nbr of controls inside this container
    }

// ---------------------------------------------------------
// CS60ResourceLabContainer::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* CS60ResourceLabContainer::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            return iLabel;
        case 1:
            return iToDoLabel;
        default:
            return NULL;
        }
    }

// ---------------------------------------------------------
// CS60ResourceLabContainer::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void CS60ResourceLabContainer::Draw(const TRect& aRect) const
    {
    CWindowGc& gc = SystemGc();
    
    gc.SetPenStyle(CGraphicsContext::ENullPen);
    gc.SetBrushColor(KRgbGray);
    gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
    gc.DrawRect(aRect);
    }

// ---------------------------------------------------------
// CS60ResourceLabContainer::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void CS60ResourceLabContainer::HandleControlEventL(
    CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
    {
    }

// End of File  
