// Copyright (c) 2006 Nokia Corporation.

// INCLUDE FILES
#include "S60ClientServLabAppUi.h"
#include "S60ClientServLabContainer.h" 
#include <S60ClientServerLab.rsg>
#include "s60ClientServerLab.hrh"

#include <avkon.hrh>

// ================= MEMBER FUNCTIONS =======================
//
// ----------------------------------------------------------
// CS60ClientServLabAppUi::ConstructL()
// ?implementation_description
// ----------------------------------------------------------
//
void CS60ClientServLabAppUi::ConstructL()
    {
    BaseConstructL();
    iAppContainer = new (ELeave) CS60ClientServLabContainer;
    iAppContainer->SetMopParent(this);
    iAppContainer->ConstructL( ClientRect() );
    AddToStackL( iAppContainer );
    }

// ----------------------------------------------------
// CS60ClientServLabAppUi::~CS60ClientServLabAppUi()
// Destructor
// Frees reserved resources
// ----------------------------------------------------
//
CS60ClientServLabAppUi::~CS60ClientServLabAppUi()
    {
    if (iAppContainer)
        {
        RemoveFromStack( iAppContainer );
        delete iAppContainer;
        }
   }

// ------------------------------------------------------------------------------
// CS60ClientServLabAppUi::::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
// ------------------------------------------------------------------------------
//
void CS60ClientServLabAppUi::DynInitMenuPaneL(
    TInt /*aResourceId*/,CEikMenuPane* /*aMenuPane*/)
    {
    }

// ----------------------------------------------------
// CS60ClientServLabAppUi::HandleKeyEventL(
//     const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
// ?implementation_description
// ----------------------------------------------------
//
TKeyResponse CS60ClientServLabAppUi::HandleKeyEventL(
    const TKeyEvent& /*aKeyEvent*/,TEventCode /*aType*/)
    {
    return EKeyWasNotConsumed;
    }

// ----------------------------------------------------
// CS60ClientServLabAppUi::HandleCommandL(TInt aCommand)
// ?implementation_description
// ----------------------------------------------------
//
void CS60ClientServLabAppUi::HandleCommandL(TInt aCommand)
    {
    switch ( aCommand )
        {
        case EAknSoftkeyBack:
        case EEikCmdExit:
            Exit();
            break;

        case ES60ClientServLabCmdWriteFile:
            iAppContainer->WriteFileL();
            break;

        default:
            break;      
        }
    }

// -----------------------------------------------------------------------------
// CS60ClientServLabAppUi::HandleScreenDeviceChangedL
// Handle change in screen resolution.
// -----------------------------------------------------------------------------
//
void CS60ClientServLabAppUi::HandleScreenDeviceChangedL()
    {
    CAknAppUi::HandleScreenDeviceChangedL();

    // Reposition the view
    if ( iAppContainer )
        {
        iAppContainer->SetRect(ClientRect());
        }
    }
    
// End of File  
