// Copyright (c) 2006 Nokia Corporation.

// INCLUDE FILES
#include "S60ClientServLabContainer.h"

#include <eiklabel.h>  // for example label control
#include <f32file.h>   // for file server usage

_LIT(KClientServerLabText, "Client/Server Lab");
_LIT(KFileWriterText, "File Writer");
_LIT(KOutputFileSizeText, "Output file size:");
_LIT(KNumBytes, "%d bytes");
_LIT(KDataFilePath, "c:\\system\\apps\\S60ClientServLab\\S60ClientServLab.txt");
_LIT8(KDataEntry, "A line of ASCII text\r\n");
// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CS60ClientServLabContainer::ConstructL(const TRect& aRect)
// EPOC two phased constructor
// ---------------------------------------------------------
//
void CS60ClientServLabContainer::ConstructL(const TRect& aRect)
    {
    CreateWindowL();

    iTopLabel = new (ELeave) CEikLabel;
    iTopLabel->SetContainerWindowL( *this );
    iTopLabel->SetTextL(KClientServerLabText);

    iBottomLabel = new (ELeave) CEikLabel;
    iBottomLabel->SetContainerWindowL( *this );
    iBottomLabel->SetTextL(KFileWriterText);

    SetRect(aRect);
    ActivateL();
    }

// Destructor
CS60ClientServLabContainer::~CS60ClientServLabContainer()
    {
    delete iTopLabel;
    delete iBottomLabel;
    }

// ---------------------------------------------------------
// CS60ClientServLabContainer::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void CS60ClientServLabContainer::SizeChanged()
    {
    iTopLabel->SetExtent( TPoint(0,0), TSize(Rect().Width(), Rect().Height()/2));
    iBottomLabel->SetExtent( TPoint(0,Rect().Height()/2), TSize(Rect().Width(),Rect().Height()/2));
    }

// ---------------------------------------------------------
// CS60ClientServLabContainer::CountComponentControls() const
// ---------------------------------------------------------
//
TInt CS60ClientServLabContainer::CountComponentControls() const
    {
    return 2; // return nbr of controls inside this container
    }

// ---------------------------------------------------------
// CS60ClientServLabContainer::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* CS60ClientServLabContainer::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            return iTopLabel;
        case 1:
            return iBottomLabel;
        default:
            return NULL;
        }
    }

// ---------------------------------------------------------
// CS60ClientServLabContainer::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void CS60ClientServLabContainer::Draw(const TRect& aRect) const
    {
    CWindowGc& gc = SystemGc();
    gc.SetPenStyle(CGraphicsContext::ENullPen);
    gc.SetBrushColor(KRgbGray);
    gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
    gc.DrawRect(aRect);
    }

// ---------------------------------------------------------
// CS60ClientServLabContainer::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void CS60ClientServLabContainer::HandleControlEventL(
    CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
    {
    }
    
// ---------------------------------------------------------
// CS60ClientServLabContainer::WriteFileL()
// ---------------------------------------------------------
//
void CS60ClientServLabContainer::WriteFileL()
    {
    RFs fs;
    User::LeaveIfError(fs.Connect());
    CleanupClosePushL(fs);

    TParsePtrC parse(KDataFilePath);
    TPtrC pathPtr = parse.DriveAndPath();

    User::LeaveIfError(fs.MkDirAll(pathPtr));

    RFile file;
    TInt ret = file.Open(fs, KDataFilePath, EFileWrite | EFileStreamText);

    switch(ret)
    	{         
		case KErrNotFound:
			User::LeaveIfError(file.Create(fs, KDataFilePath, EFileWrite | EFileStreamText));
			break;
			
		case KErrNone:
			// Do nothing
			break;
			
		default:
			User::Leave(ret);
			break;
    	}
    
	CleanupClosePushL(file);
    
    TInt offset = 0;   
	User::LeaveIfError(file.Seek(ESeekEnd, offset));
	User::LeaveIfError(file.Write(KDataEntry));
	
    TInt fileSize;
    file.Size(fileSize);
	
	CleanupStack::PopAndDestroy(2);
	
    TBuf<20> numBytes;
    numBytes.Format(KNumBytes, fileSize);

    iTopLabel->SetTextL(KOutputFileSizeText);
    iBottomLabel->SetTextL(numBytes);
    }
// End of File  
