// Copyright (c) 2006 Nokia Corporation.

#ifndef S60CLIENTSERVLABCONTAINER_H
#define S60CLIENTSERVLABCONTAINER_H

// INCLUDES
#include <coecntrl.h>
   
// FORWARD DECLARATIONS
class CEikLabel;        // for example labels

// CLASS DECLARATION

/**
*  CS60ClientServLabContainer  container control class.
*  
*/
class CS60ClientServLabContainer : public CCoeControl, MCoeControlObserver
    {
    public: // Constructors and destructor
        
        /**
        * 2nd phase constructor.
        * @param aRect Frame rectangle for container.
        */
        void ConstructL(const TRect& aRect);

        /**
        * Destructor.
        */
        ~CS60ClientServLabContainer();

    public: // New functions
        /**
        * 2nd writes Ascii data to a file.
        */
        void WriteFileL();


    private: // Functions from base classes
       /**
        * From CoeControl,SizeChanged.
        */
        void SizeChanged();

       /**
        * From CoeControl,CountComponentControls.
        */
        TInt CountComponentControls() const;

       /**
        * From CCoeControl,ComponentControl.
        */
        CCoeControl* ComponentControl(TInt aIndex) const;

       /**
        * From CCoeControl,Draw.
        */
        void Draw(const TRect& aRect) const;

       /**
        * From ?base_class ?member_description
        */
        // event handling section
        // e.g Listbox events
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);
        
    private: //data
        
        CEikLabel* iTopLabel;          
        CEikLabel* iBottomLabel;      
    };

#endif

// End of File
