// Copyright (c) 2006 Nokia Corporation.

#ifndef __S60CLIENTSERVERLABAPPLICATION_H__
#define __S60CLIENTSERVERLABAPPLICATION_H__

// INCLUDES
#include <aknapp.h>

// CLASS DECLARATION

/**
* CS60ClientServerLabApp application class.
* Provides factory to create concrete document object.
* An instance of CS60ClientServerLabApp is the application part of the
* AVKON application framework for the S60ClientServerLab example application.
*/
class CS60ClientServerLabApp : public CAknApplication
    {
    public: // Functions from base classes

        /**
        * From CApaApplication, AppDllUid.
        * @return Application's UID (KUidS60ClientServerLabApp).
        */
        TUid AppDllUid() const;

    protected: // Functions from base classes

        /**
        * From CApaApplication, CreateDocumentL.
        * Creates CS60ClientServerLabDocument document object. The returned
        * pointer in not owned by the CS60ClientServerLabApp object.
        * @return A pointer to the created document object.
        */
        CApaDocument* CreateDocumentL();
    };

#endif // __S60CLIENTSERVERLABAPPLICATION_H__

// End of File
