// Copyright (c) 2006 Nokia Corporation.

// INCLUDE FILES
#include "S60ClientServLabDocument.h"
#include "S60ClientServerLabApplication.h"

// ============================ MEMBER FUNCTIONS ===============================

// UID for the application;
// this should correspond to the uid defined in the mmp file
const TUid KUidS60ClientServerLabApp = { 0x0A72F88E };

// -----------------------------------------------------------------------------
// CS60ClientServerLabApp::CreateDocumentL()
// Creates CApaDocument object
// -----------------------------------------------------------------------------
//
CApaDocument* CS60ClientServerLabApp::CreateDocumentL()
    {
    // Create an S60ClientServerLab document, and return a pointer to it
    return (static_cast<CApaDocument*>
                    ( CS60ClientServLabDocument::NewL( *this ) ) );
    }

// -----------------------------------------------------------------------------
// CS60ClientServerLabApp::AppDllUid()
// Returns application UID
// -----------------------------------------------------------------------------
//
TUid CS60ClientServerLabApp::AppDllUid() const
    {
    // Return the UID for the S60ClientServerLab application
    return KUidS60ClientServerLabApp;
    }

// End of File
