// Copyright (c) 2006 Nokia Corporation.

#ifndef __AOLABTEXTFLASHAPPLICATION_H__
#define __AOLABTEXTFLASHAPPLICATION_H__

// INCLUDES
#include <aknapp.h>

// CLASS DECLARATION

/**
* CAOLabTextFlashApplication application class.
* Provides factory to create concrete document object.
* An instance of CAOLabTextFlashApplication is the application part of the
* AVKON application framework for the AOLabTextFlash example application.
*/
class CAOLabTextFlashApplication : public CAknApplication
    {
    public: // Functions from base classes

        /**
        * From CApaApplication, AppDllUid.
        * @return Application's UID (KUidAOLabTextFlashApp).
        */
        TUid AppDllUid() const;

    protected: // Functions from base classes

        /**
        * From CApaApplication, CreateDocumentL.
        * Creates CAOLabTextFlashDocument document object. The returned
        * pointer in not owned by the CAOLabTextFlashApplication object.
        * @return A pointer to the created document object.
        */
        CApaDocument* CreateDocumentL();
    };

#endif // __AOLABTEXTFLASHAPPLICATION_H__

// End of File
