// Copyright (c) 2006 Nokia Corporation.

#ifndef AOLABTEXTFLASHCONTAINER_H
#define AOLABTEXTFLASHCONTAINER_H

#include <coecntrl.h>
#include "activetimernotify.h"
   
class CEikLabel;
class CActiveTimer;


// Container control class
class CAOLabTextFlashContainer : public CCoeControl, MActiveTimerNotify
                               
    {
    public: // Constructors and destructor
      
		static CAOLabTextFlashContainer* NewL(const TRect& aRect);
        void ConstructL(const TRect& aRect);
        ~CAOLabTextFlashContainer();

	private: // Functions from base classes

        // From CoeControl
        void SizeChanged();
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;

        // From MActiveTimerNotify
        void TimerComplete(TInt aError);
        
    public: // Other functions
       
        void FlashingText();
        void StopFlashing();
        TBool IsFlashing() const {return iIsFlashing;}

    private: //data
        
        CEikLabel*            iTopLabel;          
        CEikLabel*            iBottomLabel;      
        CActiveTimer*         iActiveTimer;
        TBool                 iIsVisible;
        TBool                 iIsFlashing;
    };

#endif // AOLABTEXTFLASHCONTAINER_H

// End of File
