// Copyright (c) 2006 Nokia Corporation.

#ifndef _ACTIVE_TIMER_H
#define _ACTIVE_TIMER_H

#include <e32base.h>

class MActiveTimerNotify;

class CActiveTimer : public CActive
    {
    public: // construction / destruction
    
        static CActiveTimer* NewL(MActiveTimerNotify& aNotifier);
        ~CActiveTimer();

    public: // new functions
    
        void After(TTimeIntervalMicroSeconds32 anInterval);

    protected: // CActive overrides
    
        void RunL();
        void DoCancel();

    protected: // construction

        CActiveTimer(MActiveTimerNotify& aNotifier);
        void ConstructL();

    protected: // data

		RTimer iTimer;
        MActiveTimerNotify& iNotifier;
    };

#endif // _ACTIVE_TIMER_H

// End of file