// Copyright (c) 2006 Nokia Corporation.

#include <avkon.hrh>
#include <aknnotewrappers.h>
#include <stringloader.h>
#include <AOLabTextFlash.rsg>
#include <f32file.h>
#include <s32file.h>
#include "AOLabTextFlashAppUi.h"
#include "AOLabTextFlashContainer.h"
#include "AOLabTextFlash.hrh"


// Symbian 2nd phase constructor
void CAOLabTextFlashAppUi::ConstructL()
    {
    BaseConstructL();
	iAppContainer = CAOLabTextFlashContainer::NewL(ClientRect());
	}


// C++ constructor
CAOLabTextFlashAppUi::CAOLabTextFlashAppUi()
    {
    // No implementation
    }


// C++ destructor
CAOLabTextFlashAppUi::~CAOLabTextFlashAppUi()
    {
    delete iAppContainer;
    }


//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
void CAOLabTextFlashAppUi::DynInitMenuPaneL(TInt aResourceId, CEikMenuPane* aMenuPane)
    {
    if (aResourceId == R_MENU)
        {
       	if (iAppContainer->IsFlashing())
            {
            aMenuPane->SetItemTextL(ECommandFlashText, R_COMMAND_STOPFLASHING);
            }
        else
        	{
        	aMenuPane->SetItemTextL(ECommandFlashText, R_COMMAND_STARTFLASHING);
        	}
        }
    }
    
    
// Takes care of command handling.
void CAOLabTextFlashAppUi::HandleCommandL( TInt aCommand )
    {
    switch ( aCommand )
        {
        case EAknSoftkeyExit:
        case EEikCmdExit:
            Exit();
            break;

        case ECommandFlashText:
        	{
            if (iAppContainer->IsFlashing())
                {
                iAppContainer->StopFlashing();
                }
            else
                {
                iAppContainer->FlashingText();
                }
                
            break;
        	}

        default:
            break;      
        }
    }
    
    
//  Called by the framework when the application status pane
//  size is changed.
void CAOLabTextFlashAppUi::HandleStatusPaneSizeChange()
	{
	iAppContainer->SetRect( ClientRect() );
	} 

// End of File
