// Copyright (c) 2006 Nokia Corporation.

#include "AOLabTextFlashContainer.h"
#include "ActiveTimer.h"
#include <eiklabel.h>

_LIT(KHelloText, "Hello");
_LIT(KWorldText, "World");

const TInt KTimeoutValue = 2000000;


// Constructs a container for this application
CAOLabTextFlashContainer* CAOLabTextFlashContainer::NewL(const TRect& aRect)
	{
	CAOLabTextFlashContainer* self = new ( ELeave ) CAOLabTextFlashContainer();
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    CleanupStack::Pop(self);
    
    return self;
	}
	
	
// Symbian 2nd phase constructor
void CAOLabTextFlashContainer::ConstructL(const TRect& aRect)
    {
    CreateWindowL();

    iTopLabel = new (ELeave) CEikLabel;
    iTopLabel->SetContainerWindowL(*this);
    iTopLabel->SetTextL(KHelloText);

    iBottomLabel = new (ELeave) CEikLabel;
    iBottomLabel->SetContainerWindowL(*this);
    iBottomLabel->SetTextL(KWorldText);

    iActiveTimer = CActiveTimer::NewL(*this);
    iIsVisible = ETrue;

    SetRect(aRect);
    ActivateL();
    }


// C++ Destructor
CAOLabTextFlashContainer::~CAOLabTextFlashContainer()
    {
    delete iActiveTimer;
    delete iTopLabel;
    delete iBottomLabel;
    }


// Called by framework when the view size is changed
void CAOLabTextFlashContainer::SizeChanged()
    {
    iTopLabel->SetExtent( TPoint(0,0), TSize(Rect().Width(), Rect().Height()/2));
    iBottomLabel->SetExtent( TPoint(0,Rect().Height()/2), TSize(Rect().Width(),Rect().Height()/2));
    }


// Returns the number of controls inside this container
TInt CAOLabTextFlashContainer::CountComponentControls() const
    {
    return 2;
    }


// Gets an indexed component of this compound control
CCoeControl* CAOLabTextFlashContainer::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            return iTopLabel;
        case 1:
            return iBottomLabel;
        default:
            return NULL;
        }
    }


// Draw a grey rectangle that fills the client area of the screen
void CAOLabTextFlashContainer::Draw(const TRect& aRect) const
    {
    CWindowGc& gc = SystemGc();
    
    gc.SetPenStyle(CGraphicsContext::ENullPen);
    gc.SetBrushColor(KRgbGray);
    gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
    gc.DrawRect(aRect);
    }
      
      
// Starts the text flashing
void CAOLabTextFlashContainer::FlashingText()
    {
    iTopLabel->SetTextL(KHelloText);
    iBottomLabel->SetTextL(KWorldText);
    DrawNow();
        
    if (!iIsFlashing)
        {
        iIsVisible = ETrue;
        iIsFlashing = ETrue;
        iActiveTimer->After(KTimeoutValue);
        }
    }


// Stops the text flashing
void CAOLabTextFlashContainer::StopFlashing()
    {
    if (iIsFlashing)
        {
        iIsFlashing = EFalse;
        iActiveTimer->Cancel();
        }
        
    iTopLabel->MakeVisible(ETrue);
    iBottomLabel->MakeVisible(ETrue);
    }


// Callback function when the active object timer completes 
void CAOLabTextFlashContainer::TimerComplete(TInt aError)
    {
    if (KErrNone == aError)
        {
        iIsVisible = !iIsVisible;
        iActiveTimer->After(KTimeoutValue);
        }
    else
        {
        iIsVisible = ETrue;
        iIsFlashing = EFalse;
        }
        
    iTopLabel->MakeVisible(iIsVisible);
    iBottomLabel->MakeVisible(iIsVisible);
    }

// End of File  
