// Copyright (c) 2006 Nokia Corporation.

#include "ActiveTimer.h"
#include "ActiveTimerNotify.h"


// Constructs a CActiveTimer object
CActiveTimer* CActiveTimer::NewL(MActiveTimerNotify& aNotifier)
    {
    CActiveTimer* self = new (ELeave) CActiveTimer(aNotifier);
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop();
    return self;
    }


// C++ Destructor
CActiveTimer::~CActiveTimer()
    {
	Cancel();
    iTimer.Close();
    }


// Initiates the asynchronous timer request and sets the active object
// ready to handle its completion
void CActiveTimer::After(TTimeIntervalMicroSeconds32 anInterval)
    {
    iTimer.After(iStatus, anInterval);
    SetActive();
    }


// Handles the completion of the asynchronous timer request
void CActiveTimer::RunL()
    {
    iNotifier.TimerComplete(iStatus.Int());
    }


// Handles the cleanup necessary if the 
// asynchronous timer request is cancelled
void CActiveTimer::DoCancel()
    {
    iTimer.Cancel();
    }


// C++ constructor
CActiveTimer::CActiveTimer(MActiveTimerNotify& aNotifier) : 
    CActive(EPriorityStandard),
    iNotifier(aNotifier)
    {
    CActiveScheduler::Add(this);
    }


// Second-phase constructor
void CActiveTimer::ConstructL()
    {
    User::LeaveIfError(iTimer.CreateLocal());
    }

// End of file