// Copyright (c) 2006 Nokia Corporation.

#include "AOLabTextFlashAppUi.h"
#include "AOLabTextFlashDocument.h"

// Constructs a document object for this application
CAOLabTextFlashDocument* CAOLabTextFlashDocument::NewL(CEikApplication& aApp)
    {
    CAOLabTextFlashDocument* self = NewLC(aApp);
    CleanupStack::Pop(self);
    return self;
    }


// Constructs a document object for this application and places it on the cleanupstack.
CAOLabTextFlashDocument* CAOLabTextFlashDocument::NewLC(CEikApplication& aApp)
    {
    CAOLabTextFlashDocument* self = new (ELeave) CAOLabTextFlashDocument(aApp);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }


// Symbian 2nd phase constructor
void CAOLabTextFlashDocument::ConstructL()
    {
    // No implementation
    }


// C++ constructor
CAOLabTextFlashDocument::CAOLabTextFlashDocument(CEikApplication& aApp)
    : CAknDocument( aApp )
    {
    // No implementation
    }


// C++ Destructor
CAOLabTextFlashDocument::~CAOLabTextFlashDocument()
    {
    // No implementation
    }


// Called by the application framework to create the application UI object
CEikAppUi* CAOLabTextFlashDocument::CreateAppUiL()
    { 
    return (new (ELeave) CAOLabTextFlashAppUi);
    }

// End of File
