// Copyright (c) 2006 Nokia Corporation.

#ifndef __ACTIVEBUBBLESORTER_H__
#define __ACTIVEBUBBLESORTER_H__

#include <e32base.h>
#include <f32file.h>

class MBubbleSortNotify; 

class CActiveBubbleSorter : public CActive
	{
	public: // Construction/destruction

    	static CActiveBubbleSorter* NewL(MBubbleSortNotify& aNotifier);
    	~CActiveBubbleSorter();

	protected: // from CActive

		// from CActive
    	void DoCancel();
    	void RunL();
		TInt RunError(TInt aError);
		
	private: // Construction
    
    	CActiveBubbleSorter(MBubbleSortNotify& aNotifier);
    	void ConstructL();

	public: // Public functions
	
    	void StartL();
    	
	private: // Internal functions
	
		void ReadNumbersFromFileL();
		void WriteNumbersToFileL();

	private: // data
 
		TInt                iX;
		TInt                iY;
	    RArray<TInt>        iNumbersArray;
	    MBubbleSortNotify&  iNotifier;  
	};

#endif // __ACTIVEBUBBLESORTER_H__

// End of file
