// Copyright (c) 2006 Nokia Corporation.

#include <avkon.hrh>
#include <aknnotewrappers.h>
#include <stringloader.h>
#include <AOLabBubbleSort.rsg>
#include <f32file.h>
#include <s32file.h>
#include "AOLabBubbleSortAppUi.h"
#include "AOLabBubbleSortContainer.h"
#include "AOLabBubbleSort.hrh"


// Symbian 2nd phase constructor
void CAOLabBubbleSortAppUi::ConstructL()
    {
    BaseConstructL();
	iAppContainer = CAOLabBubbleSortContainer::NewL(ClientRect());
	}


// C++  constructor
CAOLabBubbleSortAppUi::CAOLabBubbleSortAppUi()
    {
    // No implementation required
    }


// C++ Destructor
CAOLabBubbleSortAppUi::~CAOLabBubbleSortAppUi()
    {
    delete iAppContainer;
    }


// Called by the EIKON framework just before it displays
// a menu pane. Its default implementation is empty, and by overriding it,
// the application can set the state of menu items dynamically according
// to the state of application data.
void CAOLabBubbleSortAppUi::DynInitMenuPaneL(TInt aResourceId, CEikMenuPane* aMenuPane)
    {
    if (aResourceId == R_MENU)
        {
       	if (iAppContainer->IsSorting())
            {
            aMenuPane->SetItemTextL(ECommandSort, R_COMMAND_CANCELSORTING);
            }
        else
        	{
        	aMenuPane->SetItemTextL(ECommandSort,R_COMMAND_STARTSORTING);
        	}
        }
    }
    

// Takes care of command handling
void CAOLabBubbleSortAppUi::HandleCommandL( TInt aCommand )
    {
    switch( aCommand )
        {
        case EEikCmdExit:
        case EAknSoftkeyExit:
        	{	
            Exit();
            break;
        	}

        case ECommandSort:
            {
            if (iAppContainer->IsSorting())
            	{
            	iAppContainer->CancelSortL();
            	}
            else
              	{
              	iAppContainer->SortL();
            	}
            break;
            }
            
        default:
            break;
        }
    }


//  Called by the framework when the application status pane size is changed.
void CAOLabBubbleSortAppUi::HandleStatusPaneSizeChange()
{
	iAppContainer->SetRect( ClientRect() );
} 

// End of File
