// Copyright (c) 2006 Nokia Corporation.

#ifndef S60AOLABCONTAINER_H
#define S60AOLABCONTAINER_H

#include <coecntrl.h>
#include "BubbleSortNotify.h"
   
class CEikLabel;
class CActiveTimer;
class CActiveBubbleSorter;

// Container control class.
class CAOLabBubbleSortContainer : public CCoeControl, MBubbleSortNotify
    {
    public: // Constructors and destructor
        
        static CAOLabBubbleSortContainer* NewL(const TRect& aRect);
        void ConstructL(const TRect& aRect);
        ~CAOLabBubbleSortContainer();

    public: // New functions
        
        void SortL();
		void CancelSortL();
		TBool IsSorting() const {return iIsSorting;}

    private: // Functions from base classes

        //CoeControl
        void SizeChanged();

		// CoeControl
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;

        // MBubbleSortNotify
        void SortComplete(TInt aError);
        
    private: //data
        
        CEikLabel*            iTopLabel;          
        CEikLabel*            iBottomLabel;      
        CActiveBubbleSorter*  iActiveBubbleSorter;
        TBool                 iIsSorting;
    };

#endif

// End of File
