// Copyright (c) 2006 Nokia Corporation.

#include "AOLabBubbleSortContainer.h"
#include "ActiveBubbleSorter.h"
#include <eiklabel.h>

_LIT(KStartActionText, "Select menu item\nto begin sorting...");
_LIT(KCancelActionText, "Select menu item\nto cancel sorting...");

_LIT(KSortingText, "Sorting...");
_LIT(KSortingComplete, "Sorting Complete.");
_LIT(KSortingError, "Sorting Error: %d");
_LIT(KSortingCancelled, "Sorting cancelled.");


// Constructs a container for this application
CAOLabBubbleSortContainer* CAOLabBubbleSortContainer::NewL(const TRect& aRect)
	{
	CAOLabBubbleSortContainer* self = new (ELeave) CAOLabBubbleSortContainer();
    CleanupStack::PushL(self);
    self->ConstructL(aRect);
    CleanupStack::Pop(self);
    
    return self;
	}


// EPOC two phased constructor
void CAOLabBubbleSortContainer::ConstructL(const TRect& aRect)
    {
    CreateWindowL();

    iTopLabel = new (ELeave) CEikLabel;
    iTopLabel->SetContainerWindowL( *this );
    iTopLabel->SetTextL(KStartActionText);

	iBottomLabel = new (ELeave) CEikLabel;
    iBottomLabel->SetContainerWindowL( *this );
    iBottomLabel->SetTextL(KNullDesC);
    
    SetRect(aRect);
    ActivateL();
    }


// Destructor
CAOLabBubbleSortContainer::~CAOLabBubbleSortContainer()
    {
    delete iBottomLabel;
	delete iTopLabel;
    }


// Called by framework when the view size is changed
void CAOLabBubbleSortContainer::SizeChanged()
    {
    iTopLabel->SetExtent( TPoint(0,0), TSize(Rect().Width(), Rect().Height()/2));
    iBottomLabel->SetExtent( TPoint(0,Rect().Height()/2), TSize(Rect().Width(),Rect().Height()/2));
    }


// Returns the number of controls inside this container
TInt CAOLabBubbleSortContainer::CountComponentControls() const
    {
    return 2; // return nbr of controls inside this container
    }


// Gets an indexed component of this compound control
CCoeControl* CAOLabBubbleSortContainer::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            return iTopLabel;
        case 1:
            return iBottomLabel;
        default:
            return NULL;
        }
    }


// Draw a grey rectangle that fills the client area of the screen
void CAOLabBubbleSortContainer::Draw(const TRect& aRect) const
    {
    CWindowGc& gc = SystemGc();
    
    gc.SetPenStyle(CGraphicsContext::ENullPen);
    gc.SetBrushColor(KRgbGray);
    gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
    gc.DrawRect(aRect);
    }


// Starts sorting
void CAOLabBubbleSortContainer::SortL()
    {
	iIsSorting = ETrue;
    iTopLabel->SetTextL(KCancelActionText);
    iBottomLabel->SetTextL(KSortingText);
    DrawNow();
    }


// Callback function called when sorting has been completed
void CAOLabBubbleSortContainer::SortComplete(TInt aError)
    {
    iIsSorting = EFalse;
    
    TBuf<20> buf;
    if (aError == KErrNone)
    	{
    	buf.Format(KSortingComplete);
    	}
    else
    	{
    	buf.Format(KSortingError, aError);
    	}
    	
    iTopLabel->SetTextL(KStartActionText);
    iBottomLabel->SetTextL(buf);
    DrawNow();
    }


// Cancels the sort
void CAOLabBubbleSortContainer::CancelSortL()
	{
	iIsSorting = EFalse;
	
	iTopLabel->SetTextL(KStartActionText);
    iBottomLabel->SetTextL(KSortingCancelled);
    DrawNow();
	}
	
// End of File  
