// Copyright (c) 2006 Nokia Corporation.

#include "ActiveBubbleSorter.h"
#include "BubbleSortNotify.h"
#include <e32math.h>

_LIT(KSortDataInputFileName, "C:\\private\\0515DFCE\\sortdata_in.dat");
_LIT(KSortDataOutputFileName, "C:\\private\\0515DFCE\\sortdata_out.dat");
_LIT8(KNumberOutputFormat, "%d\r\n");


// Constructs a CActiveBubbleSorter object
CActiveBubbleSorter* CActiveBubbleSorter::NewL()
    {
    CActiveBubbleSorter* self = new (ELeave) CActiveBubbleSorter();
    CleanupStack::PushL(self);
    self->ConstructL();
    CleanupStack::Pop(self);
    return self;
    }


// C++ Constructor
CActiveBubbleSorter::CActiveBubbleSorter()
	: CActive(CActive::EPriorityIdle)
    {
    }


// C++ Destructor
CActiveBubbleSorter::~CActiveBubbleSorter()
    {
    }


// Symbian 2nd phase construction
void CActiveBubbleSorter::ConstructL()
    {
    // Do nothing
    }


// Handles the cleanup necessary if sorting is cancelled
void CActiveBubbleSorter::DoCancel()
    {
    }


// Handles each step of the sorting procedure
void CActiveBubbleSorter::RunL()
    {
    }


// Called to begin sorting
void CActiveBubbleSorter::StartL()
	{
	}
	
	
// Reads numbers from an input file into an RArray
void CActiveBubbleSorter::ReadNumbersFromFileL()
    {
    // Read contents of the input file into a descriptor
    RFs fs;
    User::LeaveIfError(fs.Connect());
    CleanupClosePushL(fs);
    
    RFile file;
    User::LeaveIfError(file.Open(fs, KSortDataInputFileName, EFileStreamText | EFileRead));
    CleanupClosePushL(fs);
    
    TInt sz = 0;
    User::LeaveIfError(file.Size(sz));
    
    HBufC8* buf = HBufC8::NewLC(sz);
    TPtr8 ptr = buf->Des();
    User::LeaveIfError(file.Read(ptr));
    
    // Extract numbers from the descriptor containing the contents of the input file
    TLex8 lx(ptr);
    TBool finshed = EFalse;
    while (!finshed)
    	{
    	if (lx.Eos())
    		{
    		finshed = ETrue;
    		}
    	else if ((lx.Peek()).IsDigit()) 
    		{
    		TInt num;
    		TInt err = lx.Val(num);
    		iNumbersArray.Append(num);
    		}
    	else
    		{
    		lx.Inc();
    		}
    	}
    
    CleanupStack::PopAndDestroy(3); // automatically closes fs and file
    }


// Writes the numbers in the RArray to an output file
void CActiveBubbleSorter::WriteNumbersToFileL()
    {
    RFs fs;
    User::LeaveIfError(fs.Connect());
    CleanupClosePushL(fs);
    
    TInt ret = fs.Delete(KSortDataOutputFileName);
    if (!(ret == KErrNone || ret == KErrNotFound))
    	{
    	User::Leave(ret);
    	} 
    
    RFile file;
    User::LeaveIfError(file.Create(fs, KSortDataOutputFileName, EFileStreamText | EFileWrite));
    CleanupClosePushL(fs);
    
    TBuf8<10> buf;
    
    for (TInt i = 0; i < iNumbersArray.Count(); i++)
    	{
    	buf.Format(KNumberOutputFormat, iNumbersArray[i]);
    	file.Write(buf);
    	}
    	
    CleanupStack::PopAndDestroy(2); // automatically closes fs and file
    }
    
    
// Called in the event the RunL function leaves
TInt CActiveBubbleSorter::RunError(TInt aError)
	{
   	iNumbersArray.Reset();
	iNotifier.SortComplete(aError);
	
	return KErrNone;
	}
	
// End of file
