// Copyright (c) 2005-2009 Nokia Corporation and/or its subsidiary(-ies).
// All rights reserved.
// This component and the accompanying materials are made available
// under the terms of "Eclipse Public License v1.0"
// which accompanies this distribution, and is available
// at the URL "http://www.eclipse.org/legal/epl-v10.html".
//
// Initial Contributors:
// Nokia Corporation - initial contribution.
//
// Contributors:
//
// Description:
//

#include "CLifeEngine.h"
#include "Direct.h"
#include "CDirectDisplayLife.h"

#include <eikenv.h>
#include <eikmenub.h>

#include <eikspane.h>

#include <eikstart.h>

//
// CExampleAppView
//

CExampleAppView::CExampleAppView(CLifeEngine& aLifeEngine)
: iLifeEngine(aLifeEngine)
	{
	}

void CExampleAppView::ConstructL(const TRect& aRect)
	{
	// Create window
	CreateWindowL();
	SetRect(aRect);

	// Set up direct displayer for life engine
	iDirectDisplayLife = new (ELeave) CDirectDisplayLife (
		iEikonEnv->WsSession(),		// Window server session
		Window(),					// The window itself
		iLifeEngine);
	iDirectDisplayLife -> ConstructL();

	ActivateL();
	}

CExampleAppView::~CExampleAppView()
	{
	delete iDirectDisplayLife;
	}

// Start using the DSA
void CExampleAppView::StartDirectL()
	{
	iDirectDisplayLife -> StartL();
	iState = EDirectStarted;
	}

// Pause use of the DSA
void CExampleAppView::PauseDirect()
	{
	iState = EDirectPaused;	
	iDirectDisplayLife -> Cancel();
	}

// Restart use of the DSA after pausing
void CExampleAppView::RestartDirect()
	{
	iState = EDirectStarted;
	iDirectDisplayLife -> Restart(RDirectScreenAccess::ETerminateCancel);
	}

// Gets the view state
TInt CExampleAppView::State() const
	{
	return iState;
	}


void CExampleAppView::Draw(const TRect& /*aRect*/) const
	{
	CWindowGc& gc = SystemGc();
	// white out whole rectangle
	TRect rect=Rect();
	gc.SetPenStyle(CGraphicsContext::ENullPen);
	gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
	gc.SetBrushColor(KRgbWhite);
	gc.DrawRect(rect);
	// border
	rect.Shrink(10,10);
	gc.SetBrushStyle(CGraphicsContext::ENullBrush);
	gc.SetPenStyle(CGraphicsContext::ESolidPen);
	gc.DrawRect(rect);
	}


//
// CExampleAppUi
//

void CExampleAppUi::ConstructL()
	{
	BaseConstructL();

	// Construct the view
	iAppView=new(ELeave) CExampleAppView(static_cast<CExampleDocument*>(Document())->LifeEngine());
	iAppView->ConstructL(ClientRect());

	// Construct the example overlaying dialog
	iOverlayDialog = new (ELeave) COverlayDialog();
	CActiveScheduler::Add(iOverlayDialog);
	}

CExampleAppUi::~CExampleAppUi()
	{
	delete iAppView;
	iOverlayDialog->Cancel();
	delete iOverlayDialog;
	}

// Handle menu commands
void CExampleAppUi::HandleCommandL(TInt aCommand)
	{
	switch (aCommand)
		{
	// Start command
	case EExampleCmd1:
		// Different action required for very first start
		// And subsequent restarts
		if (iAppView -> State() == CExampleAppView::EDirectNotStarted)
			iAppView -> StartDirectL();
		else
			{
			iAppView -> PauseDirect();
			static_cast<CExampleDocument*>(Document())->LifeEngine().Reset();
			iAppView -> RestartDirect();
			}
		break;
	// Test overlay command
	case EExampleCmd2:
		iOverlayDialog->ShowDialog();
		break;
	// Close command
	case EEikCmdExit: 
		Exit();
		break;
		}
	}

//
// CExampleAppUi::COverlayDialog
//

CExampleAppUi::COverlayDialog::COverlayDialog()
:CActive(EPriorityStandard)
	{
	iNotifier.Connect();
	}

CExampleAppUi::COverlayDialog::~COverlayDialog()
	{
	Cancel();
	iNotifier.Close();
	}

void CExampleAppUi::COverlayDialog::ShowDialog()
	{
	_LIT(KLine1,"Overlaying dialog");
	_LIT(KLine2,"Owned by another thread");
	_LIT(KBut,"OK");

	// Use a notifier to display a dialog from the notifier server thread
	iNotifier.Notify(KLine1,KLine2,KBut,KBut,iR,iStatus);
	SetActive();
	}

void CExampleAppUi::COverlayDialog::RunL()
	{
	// Don't care what the dialog returned
	}

void CExampleAppUi::COverlayDialog::DoCancel()
	{
	}

//
// CExampleDocument
//

CExampleDocument::CExampleDocument(CEikApplication& aApp)
		: CEikDocument(aApp)
	{
	}

CExampleDocument::~CExampleDocument()
	{
	delete iLifeEngine;
	}

CLifeEngine& CExampleDocument::LifeEngine() const
	{
	return *iLifeEngine;
	}

CEikAppUi* CExampleDocument::CreateAppUiL()
	{
	// Get a random seed from the timer
	User::After(1);
	TTime now;
	now.HomeTime();

	// Create engine
	iLifeEngine = new (ELeave) CLifeEngine(now.Int64());
	return new(ELeave) CExampleAppUi;
	}

//
// CExampleApplication
//

TUid CExampleApplication::AppDllUid() const
	{
	return KUidExample;
	}

CApaDocument* CExampleApplication::CreateDocumentL()
	{
	return new (ELeave) CExampleDocument(*this);
	}

//
// DLL interface
//

EXPORT_C CApaApplication* NewApplication()
	{
	return new CExampleApplication;
	}

										
extern TInt E32Main()		
	{
	return EikStart::RunApplication(NewApplication);
	}
