/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef INTERNETEMAILAPPUI_H
#define INTERNETEMAILAPPUI_H

// INCLUDES
#include <eikapp.h>
#include <eikdoc.h>
#include <e32std.h>
#include <coeccntx.h>
#include <aknappui.h>

#include <aknnotewrappers.h> // for notes
#include <aknwaitdialog.h>  //for progress dialog
#include "internetemailengine.h"

// FORWARD DECLARATIONS
class CInternetEmailContainer;
class CInternetEmailDocument;
class CInternetEmailEngine;


// CONSTANTS
//const ?type ?constant_var = ?constant;


// CLASS DECLARATION

/**
* Application UI class.
* Provides support for the following features:
* - EIKON control architecture
* 
*/
class CInternetEmailAppUi : public CAknAppUi, public MInternetEmailEngineObserver, public MProgressDialogCallback
    {
    public: // // Constructors and destructor

        /**
        * EPOC default constructor.
        */      
        void ConstructL();

        /**
        * Destructor.
        */      
        ~CInternetEmailAppUi();
        
    public: // New functions
        CInternetEmailEngine* Model();

    public: // Functions from base classes

        // From MInternetEmailEngineObserver
        void HandleEngineChangedEventL(TInternetEmailEngineEvent aEvent);

        // From MProgressDialogCallback
        void DialogDismissedL(TInt aButtonId);

    private:
        // From MEikMenuObserver
        void DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane);
        CInternetEmailDocument* Document();
        void ShowNoteL( const TInt &aResId ) const;

    private:
        /**
        * From CEikAppUi, takes care of command handling.
        * @param aCommand command to be handled
        */
        void HandleCommandL(TInt aCommand);

        /**
        * From CEikAppUi, handles key events.
        * @param aKeyEvent Event to handled.
        * @param aType Type of the key event. 
        * @return Response code (EKeyWasConsumed, EKeyWasNotConsumed). 
        */
        virtual TKeyResponse HandleKeyEventL(
            const TKeyEvent& aKeyEvent,TEventCode aType);

    private: //Data
        CInternetEmailContainer* iAppContainer; //to handle our main listbox based view
        CInternetEmailEngine* iModel; //to call main engine and initiate action
        CAknWaitDialog *iWaitDialog;  //for better user experience
    };

#endif

// End of File
