/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef INTERNETEMAILCONTAINER_H
#define INTERNETEMAILCONTAINER_H

// INCLUDES
#include <coecntrl.h>

#include <aknlists.h> //for listbox
#include <eiklbo.h>   //for listboxobserver
#include <badesca.h>  //string arrays

#include "InternetEmailEngine.h" //for lazyness
#include "InternetEmailAppUi.h" //for lazyness
   
// FORWARD DECLARATIONS
class  CInternetEmailEngine;
class  CInternetEmailAppUi;

// CLASS DECLARATION

/**
*  CInternetEmailContainer  container control class.
*  
*/
class CInternetEmailContainer : public CCoeControl, MCoeControlObserver, MEikListBoxObserver, MDesCArray
    {
    public: // Constructors and destructor
        
        /**
        * EPOC default constructor.
        * @param aRect Frame rectangle for container.
        */
        void ConstructL(const TRect& aRect, CInternetEmailAppUi* aParent);

        /**
        * Destructor.
        */
        ~CInternetEmailContainer();

    public: // New functions
        /**
         * void MailCountChange()
         *  funtion called from engine observer 
         *  callback handlers when model changes are 
         *  occurring.
         */
        void MailCountChange();

    private: // New functions

        /**
         * void OpenEmailL()
         *  Calls generic messaging api and uses it to open
         *  selected message entry.
         */
        void OpenEmailL();
        
    public: // Functions from base classes

    private: // Functions from base classes
        // from MDesCArray
        TInt MdcaCount() const;
        TPtrC MdcaPoint(TInt aIndex) const;
        void EntryToListbox(TInt aIndex) const;

        /**
         * From CCoeControl, Handles key event.
         * @param aKeyEvent The key event.
         * @param aType The type of the event.
         * @return Indicates whether or not the key event was
         *           used by this control.
         */
         TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,
                                    TEventCode aType);

        // From CoeControl,SizeChanged.
        void SizeChanged();
        TInt CountComponentControls() const;
        CCoeControl* ComponentControl(TInt aIndex) const;
        void Draw(const TRect& aRect) const;

        // MCoeControlObserver
        void HandleControlEventL(CCoeControl* aControl,TCoeEvent aEventType);

        // from MEikListBoxObserver
        void HandleListBoxEventL(CEikListBox* aListBox,TListBoxEvent aEventType);
        
        void HandleResourceChange(TInt aType);

    private: //data
        
        CEikTextListBox* iListBox;    // to view entries
        CInternetEmailAppUi* iParent; // for easier access to appui
        mutable TBuf<255> iText;      // because we are also an array

    };

#endif

// End of File
