/*
 * Copyright  2008 Nokia Corporation.
 */


#ifndef INTERNETEMAILENGINE_H
#define INTERNETEMAILENGINE_H

// INCLUDES
#include <e32std.h>
#include <e32base.h>
#include <msvapi.h>     //of MsvSession
#include <imapset.h>
#include <pop3set.h>

#include <msventry.h>
#include <msvids.h>
#include <mtclreg.h>    // for CClientMtmRegistry
#include <mtclbase.h>   // for CBaseMtm
#include <mtmuibas.h>   // for CBaseMtmUi
#include <mtuireg.h>        // for CMtmUiRegistry
#include <miutset.h>

#include <popcmtm.h>    // for POP( commmands )
#include <impcmtm.h>    // for IMAP( commands )

#include "internetemail.hrh"

// FORWARD DECLARATIONS

// CONSTANTS

// not needed in one protocol implementation
enum TProtocolType
    {
    EProtocolNULL,
    EProtocolPop3,
    EProtocolImap4
    };

enum TInternetEmailEngineEvent
    {
    ERemoteCountChanged,
    };

// CLASS DECLARATION

/*
* ============================================================================
*  Name     : MInternetEmailEngineObserver from InternetEmailEngine.h
*  Part of  : InternetEmail
*  Created  : 09/11/2003 by Forum Nokia
*  Implementation notes:
*       Common observer which issues events to listening UI elements
*
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/

class MInternetEmailEngineObserver
    {
public:
    virtual void HandleEngineChangedEventL(TInternetEmailEngineEvent aEvent)=0;
    };
/*
* ============================================================================
*  Name     : CInternetEmailEngine from InternetEmailEngine.h
*  Part of  : InternetEmail
*  Created  : 09/11/2003 by Forum Nokia
*  Implementation notes:
*       Statemachine which handles events common for both
*       implemented protocols IMAP and POP. Note the selection
*       which protocol to use is one time only and load and store
*       functionality have been cutted off for maintaining focus
*       on basic receive-and-handle-with-mtm-generic-view functionality.
*
*  Version  : 1.0
*  Copyright: Nokia Corporation
* ============================================================================
*/
class CInternetEmailEngine : public CActive, public MMsvSessionObserver
    {
    public: // // Constructors and destructor
        static CInternetEmailEngine* NewL(MInternetEmailEngineObserver& aObserver);
        //static CInternetEmailEngine* NewLC();
        ~CInternetEmailEngine();

    public: // New functions
        // MAIN USER API

        /*
        * RemoteOpenEmailL(TInt aIndex)
        *
        * Uses generic messaging architecture and opens selected message entry.
        * May generate dial-up connection to fetch message body.
        *
        * @param TInt aIndex        index to message entry to be opened
        *
        */
        void  RemoteOpenEmailL( const TInt aIndex);

        /*
        * void  RemoteFetchL()
        *
        * Initiates remote mailbox fetch process
        *
        */
        void  RemoteFetchL();

        /*
        * void  SetProtocolL( const TInt aType );
        *
        * @param TInt aType type enumeration of selected type
        */
        void  SetProtocolL( const TInt aType ); // not needed in one protocol implementation
        TBool IsProtocolSet();                  // not needed in one protocol implementation

        // For view handling( see InternetEmailContainer )
        TPtrC RemoteEmailTextL( const TInt aIndex);
        TPtrC RemoteEmailSenderL( const TInt aIndex);
        TInt  RemoteEmailCount();

        TBool IsEngineReady();

        /*
        * TBool CheckIfExistsL( const TInt typeenum )
        *   Checks if service entry( Email settings ) exists for
        *   given internet email protocol type.
        *
        * @param const TInt aTypeEnum   type enumeration of given protocol type
        * @return TBool ETrue           if protocol of given type exists
        *
        */
        TBool CheckIfExistsL( const TInt aTypeEnum );

        void CancelOperation();
        void Queue();

    public: // Functions from base classes
        // from CActive
        void RunL();
        void DoCancel();
        TInt RunError( const TInt aError);

        // from MMsvSessionObserver
        void HandleSessionEventL(TMsvSessionEvent aEvent,TAny* aArg1,TAny* aArg2,TAny* aArg3);

    // private
    private:
        CInternetEmailEngine( MInternetEmailEngineObserver& aObserver );
        void ConstructL();
        void CompleteConstructL();
        void DisplayMessageL( const TMsvId &aId );
        TMsvId FindServiceL( const TUid aType );
        TMsvId FindFolderThenServiceL( const TUid aType ); // not needed in one protocol implementation
        void MailCommandL( const TInt aCommand, TDes8& aParams );
        void LoadMtmL();
        CBaseMtm* InstantiateClientMtmL( TMsvId aService, const TUid aType );

        //for update
        CMsvEntrySelection* UpdateEntriesL(const TMsvId& aServiceId);
        void UpdateRemoteCountL();

    // private types
    private:

    // internal state indication
    enum TInternalState
        {
        EInitialising,
        EReadyButNeedsProtocol,
        EReady,
        EConnecting,
        EFetching,      
        EDisconnecting,
        EDone,
        ECanceling
        };

    private: //Data
    MInternetEmailEngineObserver& iObserver; //informs ui when to react to entry changes

    CMsvSession* iMsvSession; //the server session itself, our highway to kernel space 
    CClientMtmRegistry* iClientReg; //registry used to find client mtm of given protocol type
    CMtmUiRegistry* iUiReg; //registry used to instantiante views of given mtm
    CMsvOperation* iMsvOp;  //long lasting email operation object, used e.g. for cancelling requests

    TMsvId iServiceId;      //service id of either protocol used e.g. as 
    TMsvId iId;             //id of the mailbox( POP ) or inbox( IMAP ) used as a root of messagelist
    TInternalState iState;  //the state of the statemachine we implement by this engine

    CMsvEntrySelection* iRemoteEntries; //array of entries used also as mailcommmand argument
    TInt iRemoteCount;      //count of message entries in given folder or mailbox

    CBaseMtm* iMtm;         //abstract mtm for use of both pop and imap 
    CMsvEntry* iEntry;      //current selected entry 

    // next members not needed in one protocol implementation
    TBool iIsProtocolSet;   //bool if protocol has been selected by user or not?
    TBool iHasImapInbox;    //boot have we made folder sync and got inbox?
    TInt iProtocolType;     //type of selected protocol, custom enumeration
    TUid iProtocolUid;      //uid of selected protocol for easier abstraction

    };

#endif

// End of File
