/*
 * Copyright  2008 Nokia Corporation.
 */


// INCLUDE FILES
#include "InternetEmailAppUi.h"
#include "InternetEmailContainer.h"
#include "InternetEmailDocument.h"
#include "InternetEmailEngine.h"

#include <eikmenup.h>        // for Menupanes
#include <stringloader.h>    // for easy resource usage

#include <InternetEmail.rsg>
#include "internetemail.hrh"

#include <avkon.hrh>

// ================= MEMBER FUNCTIONS =======================
//

// ----------------------------------------------------------
// CInternetEmailAppUi::ConstructL()
//  EPOC two phased constructor
// ----------------------------------------------------------
//
void CInternetEmailAppUi::ConstructL()
    {

    BaseConstructL(CAknAppUi::EAknEnableSkin);

    iModel = CInternetEmailEngine::NewL(*this); //Must be first in this solution
    iAppContainer = new (ELeave) CInternetEmailContainer;
    iAppContainer->SetMopParent(this);
    iAppContainer->ConstructL( ClientRect(), this );
    AddToStackL( iAppContainer );
    }

// ----------------------------------------------------
// CInternetEmailAppUi::~CInternetEmailAppUi()
// ----------------------------------------------------
//
CInternetEmailAppUi::~CInternetEmailAppUi()
    {
    delete iModel;
    delete iWaitDialog;

    if (iAppContainer)
        {
        RemoveFromStack( iAppContainer );
        delete iAppContainer;
        }
   }

// -------------------------------------------------------
// CInternetEmailDocument* CInternetEmailAppUi::Document()
// -------------------------------------------------------
//
CInternetEmailDocument* CInternetEmailAppUi::Document()
    {
    return static_cast<CInternetEmailDocument*>(iDocument);
    }

// -------------------------------------------------------------------------------
// CInternetEmailAppUi::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
//
//  Here we argue that user must first select one protocol to use before
//  starting the application. We do this buy dimming the menupane choices
//  that should not be possible in different states. We also dim the choices
//  to fetch mail until MsvServer session is ready.
// -------------------------------------------------------------------------------
//
void CInternetEmailAppUi::DynInitMenuPaneL(
    TInt aResourceId,CEikMenuPane* aMenuPane)
    {
    if (aResourceId == R_INTERNETEMAIL_MENU)
        {
        if (iModel->IsProtocolSet())
            {
            if( iModel->IsEngineReady() )
                {
                aMenuPane->SetItemDimmed(EInternetEmailCmdProtocol, ETrue);
                aMenuPane->SetItemDimmed(EInternetEmailCmdFetch, EFalse);
                }
            else //if MsvServer session is not ready but protocol is selected
                {
                aMenuPane->SetItemDimmed(EInternetEmailCmdProtocol, EFalse);
                aMenuPane->SetItemDimmed(EInternetEmailCmdFetch, EFalse);
                }

            }
        else //we dim all if user have not picked the protocol to use.
            {
            aMenuPane->SetItemDimmed(EInternetEmailCmdProtocol, EFalse);
            aMenuPane->SetItemDimmed(EInternetEmailCmdFetch, ETrue);
            }
        }
    }

// ----------------------------------------------------
// CInternetEmailAppUi::HandleKeyEventL(
//   const TKeyEvent& aKeyEvent,TEventCode /*aType*/)
// ----------------------------------------------------
//
TKeyResponse CInternetEmailAppUi::HandleKeyEventL(
    const TKeyEvent& /*aKeyEvent*/,TEventCode /*aType*/)
    {
    return EKeyWasNotConsumed;
    }

// -----------------------------------------------------
// CInternetEmailAppUi::HandleCommandL(TInt aCommand)
//  Here we handle the commands user interface offers to
//  user.
// -----------------------------------------------------
//
void CInternetEmailAppUi::HandleCommandL(TInt aCommand)
    {
    switch ( aCommand )
        {
        case EAknSoftkeyExit:
        case EEikCmdExit:
            {
            Exit();
            }
            break;

        case EInternetEmailCmdFetch:
            {
            // 1. first we initiate asynchornous mailcommand
            iModel->RemoteFetchL();

            // 2. then we show modal wait dialog to user
            iWaitDialog = new (ELeave) CAknWaitDialog(
            reinterpret_cast<CEikDialog**> (&iWaitDialog));
            iWaitDialog->SetCallback(this);
            iWaitDialog->ExecuteLD( R_WAIT_NOTE ); //resource based dialog
            }
            break;

        case EInternetEmailCmdSetPop:
            {
            if( !iModel->CheckIfExistsL( EProtocolPop3 ) )
                {
                ShowNoteL(R_NO_POP3_DEFINED);
                }
            else
                {
                iModel->SetProtocolL( EProtocolPop3 );
                }
            }
            break;

        case EInternetEmailCmdSetImap:
            {
            if( !iModel->CheckIfExistsL( EProtocolImap4 ) )
                {
                ShowNoteL(R_NO_IMAP4_DEFINED);
                }
            else
                {
                iModel->SetProtocolL( EProtocolImap4 );
                }
            }
            break;

        default:
            break;
        }
    }

// --------------------------------------------------
// CInternetEmailEngine* CInternetEmailAppUi::Model()
// --------------------------------------------------
//
CInternetEmailEngine* CInternetEmailAppUi::Model()
    {
    return iModel;
    }


// -------------------------------------------------
// void CInternetEmailAppUi::ShowNote( TInt aResId )
//  helper method which creates CAknInformation note
//  from localized resource files with given res.id.
// -------------------------------------------------
//
void CInternetEmailAppUi::ShowNoteL( const TInt &aResId ) const
    {
        HBufC* textResource = StringLoader::LoadLC( aResId );
        CAknInformationNote* informationNote = new (ELeave) CAknInformationNote;
        informationNote->ExecuteLD(textResource->Des());
        CleanupStack::PopAndDestroy(textResource);
    }

// --------------------------------------------------------------------------------
// CInternetEmailAppUi::HandleEngineChangedEventL(TInternetEmailEngineEvent aEvent)
//  From MInternetEmailEngineObserver.
//  Callback which is called from CInternetEmailEngine when email view
//  needs to be updated as model have changed. This event is also used to
//  close wait dialog.
// --------------------------------------------------------------------------------
//
void CInternetEmailAppUi::HandleEngineChangedEventL(TInternetEmailEngineEvent aEvent)
    {
    switch(aEvent)
        {
        case ERemoteCountChanged:
            {
            if( iWaitDialog ) //signal waitdialog to finish
                {
                iWaitDialog->ProcessFinishedL();
                delete iWaitDialog;
                iWaitDialog = NULL;
                }
            iAppContainer->MailCountChange();
            iAppContainer->DrawDeferred();
            }
            break;
        }
    }

// --------------------------------------------------------------
// void CInternetEmailAppUi::DialogDismissedL(TInt /*aButtonId*/)
//  From MProgressDialogCallback.
//  Callback which is called from CAknWaitDialog if
//  user has dismissed the wait note.
// --------------------------------------------------------------
//
void CInternetEmailAppUi::DialogDismissedL(TInt /*aButtonId*/)
    {
    iModel->CancelOperation();
    }

// End of File
