/*
 * Copyright  2008 Nokia Corporation.
 */


// INCLUDE FILES
#include "InternetEmailContainer.h"

#include <eiklabel.h>  // for example label control
#include <aknutils.h>  // for Fonts.
#include <aknlists.h>  // for listbox
#include <barsread.h>  // for resource reader
#include <avkon.hrh>

#include "Internetemail.hrh"
#include "InternetEmailEngine.h"
#include <Internetemail.rsg>


// ================= MEMBER FUNCTIONS =======================

// -------------------------------------------------------
// CInternetEmailContainer::ConstructL(const TRect& aRect)
//  EPOC two phased constructor
// -------------------------------------------------------
//
void CInternetEmailContainer::ConstructL(const TRect& aRect, CInternetEmailAppUi* aParent )
    {
    iParent=aParent;
    CreateWindowL();

    iListBox = new (ELeave) CAknDoubleStyleListBox;
    iListBox->SetContainerWindowL(*this);
    iListBox->ConstructL(this, EAknListBoxSelectionList);

    iListBox->Model()->SetItemTextArray(this); //we make ourself to be the array
    iListBox->Model()->SetOwnershipType(ELbmDoesNotOwnItemArray); //thus lb doesnt control our deletion

    iListBox->SetListBoxObserver( this );
    iListBox->CreateScrollBarFrameL(ETrue); //we set automatic scrollbar
    iListBox->ScrollBarFrame()->SetScrollBarVisibilityL(
        CEikScrollBarFrame::EOff, CEikScrollBarFrame::EAuto );

    iListBox->SetRect( aRect );
    iListBox->ActivateL();

    // set window size
    SetRect(aRect);

    // activate window
    ActivateL();
    }

// ---------------------------------------------------
// CInternetEmailContainer::~CInternetEmailContainer()
// ---------------------------------------------------
//
CInternetEmailContainer::~CInternetEmailContainer()
    {
    delete iListBox;
    }


// --------------------------------------------------
// CInternetEmailContainer::SizeChanged()
//  Called by framework when the view size is changed
// --------------------------------------------------
//
void CInternetEmailContainer::SizeChanged()
    {
    iListBox->SetRect( Rect() );
    }

// -------------------------------------------------------
// CInternetEmailContainer::CountComponentControls() const
// -------------------------------------------------------
//
TInt CInternetEmailContainer::CountComponentControls() const
    {
    return 1;
    }

// ------------------------------------------------------------
// CInternetEmailContainer::ComponentControl(TInt aIndex) const
// ------------------------------------------------------------
//
CCoeControl* CInternetEmailContainer::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            return iListBox;
        default:
            return NULL;
        }
    }

void CInternetEmailContainer::HandleResourceChange(TInt aType)
    {
    CCoeControl::HandleResourceChange(aType);
    if ( aType==KEikDynamicLayoutVariantSwitch )
        {
        TRect rect;
        AknLayoutUtils::LayoutMetricsRect(AknLayoutUtils::EMainPane, rect);
        SetRect(rect);
        }
    }

// -------------------------------------------------------
// CInternetEmailContainer::Draw(const TRect& aRect) const
// -------------------------------------------------------
//
void CInternetEmailContainer::Draw(const TRect& aRect) const
    {
    CWindowGc& gc = SystemGc();
    gc.SetPenStyle(CGraphicsContext::ENullPen);
    gc.SetBrushColor(KRgbGray);
    gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
    gc.DrawRect(aRect);
    }

// ------------------------------------------------------
// TKeyResponse CInternetEmailContainer::OfferKeyEventL(
//      const TKeyEvent& aKeyEvent, TEventCode aType)
//  This function is used to pick subset of keyevents for
//  our custom handler.
// ------------------------------------------------------
//
TKeyResponse CInternetEmailContainer::OfferKeyEventL(
    const TKeyEvent& aKeyEvent, TEventCode aType)
    {
    if ( aType != EEventKey )
        {
        return EKeyWasNotConsumed;
        }

    switch ( aKeyEvent.iCode )
        {
        // Up & Down & enter arrow key's event transfer to list box
        case EKeyOK:
        case EKeyUpArrow:
        case EKeyDownArrow:
            if ( iListBox )
                {
                return iListBox->OfferKeyEventL( aKeyEvent, aType );
                }
            break;

        default:
            break;
        }

    return EKeyWasNotConsumed;
    }

// -----------------------------------------------
// CInternetEmailContainer::HandleControlEventL(
//   CCoeControl* aControl,TCoeEvent aEventType)
// -----------------------------------------------
//
void CInternetEmailContainer::HandleControlEventL(
    CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
    {
    // TODO: Add your control event handler code here
    }


// ------------------------------------------------
// CInternetEmailContainer::HandleListBoxEventL(
//  CEikListBox* aListBox,TListBoxEvent aEventType)
//  Custom event handler.
// ------------------------------------------------
//
void CInternetEmailContainer::HandleListBoxEventL(
    CEikListBox* aListBox,TListBoxEvent aEventType)
    {
    if(aListBox==iListBox &&
    ( aEventType==MEikListBoxObserver::EEventEnterKeyPressed ||
      aEventType == MEikListBoxObserver::EEventItemClicked || 
      aEventType == MEikListBoxObserver::EEventItemDoubleClicked))
        {
        OpenEmailL(); // opens selected entry using generic framework
        }
    }

// ----------------------------------------------------
// void CInternetEmailContainer::OpenEmailL()
//  function to call engine interface method
// ----------------------------------------------------
//
void CInternetEmailContainer::OpenEmailL()
    {
    TInt currentItem=iListBox->CurrentItemIndex();
    if(currentItem>=0 && currentItem<iParent->Model()->RemoteEmailCount())
        {
        iParent->Model()->RemoteOpenEmailL(currentItem);
        }
    }

// ---------------------------------------------------------------
// void CInternetEmailContainer::EntryToListbox(TInt aIndex) const
//  Gets header message entry header information from model
//  if model is suddenly cancelled traps and draws blanco.
// ---------------------------------------------------------------
//
void CInternetEmailContainer::EntryToListbox(TInt aIndex) const
    {
    TPtrC from;
    TPtrC subject;

    TRAPD(error,from.Set(iParent->Model()->RemoteEmailSenderL(aIndex)));
    if(error == KErrNone)
        {
        TRAP(error,subject.Set(iParent->Model()->RemoteEmailTextL(aIndex)));
        if(error == KErrNone)
            {
            iText.Format(_L("\t%S\t%S"),&subject,&from);
            }
        else
            {
            iText.Zero();
            }
        }
    else
        {
        iText.Zero();
        }
    }

// ------------------------------------------------------------
// TInt CInternetEmailContainer::MdcaCount() const
//  From MDesCArray. Handles counting of array items from model
// ------------------------------------------------------------
//
TInt CInternetEmailContainer::MdcaCount() const
    {
    return iParent->Model()->RemoteEmailCount();
    }

// -----------------------------------------------------------
// TPtrC CInternetEmailContainer::MdcaPoint(TInt aIndex) const
//  From MDesCArray. Handles the insertion of needed text from
//  model to pointed member of array.
// -----------------------------------------------------------
//
TPtrC CInternetEmailContainer::MdcaPoint(TInt aIndex) const
    {
    EntryToListbox(aIndex);
    return iText;
    }

// -------------------------------------------------
// void CInternetEmailContainer::MailCountChange()
//  Public funtion called from engine observer
//  callback handlers when model changes are
//  occurring.
// -------------------------------------------------
//
void CInternetEmailContainer::MailCountChange()
    {
    iListBox->HandleItemAdditionL();

    //a trick to set default selection when model changes from N to 1
    TInt currentItem = iListBox->CurrentItemIndex();
    if(currentItem>=0 && currentItem<iParent->Model()->RemoteEmailCount())
        {
        if( iListBox->ScrollBarFrame() )
            {
            iListBox->ScrollBarFrame()->MoveVertThumbTo( currentItem );
            }
        }
    }


// End of File
