/*
 * Copyright  2008 Nokia Corporation.
 */


// INCLUDE FILES
#include "InternetEmailDocument.h"
#include "InternetEmailAppUi.h"
#include "InternetEmailEngine.h"

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------------------
// CInternetEmailDocument::CInternetEmailDocument(CEikApplication& aApp)
//  : CAknDocument(aApp) 
// ---------------------------------------------------------------------
//
CInternetEmailDocument::CInternetEmailDocument(CEikApplication& aApp)
: CAknDocument(aApp)    
    {
    }

// ---------------------------------------------------------------------
// CInternetEmailDocument::~CInternetEmailDocument()
// ---------------------------------------------------------------------
//
CInternetEmailDocument::~CInternetEmailDocument()
    {
    }

// ---------------------------------------------------------------------
// CInternetEmailDocument::~CInternetEmailDocument()
//  EPOC default constructor can leave.
// ---------------------------------------------------------------------
//
void CInternetEmailDocument::ConstructL()
    {
    }

// ---------------------------------------------------------------------
// CInternetEmailDocument* CInternetEmailDocument::NewL(
//      CEikApplication& aApp)     
//  Two-phased constructor.
// ---------------------------------------------------------------------
CInternetEmailDocument* CInternetEmailDocument::NewL(
        CEikApplication& aApp)     // CInternetEmailApp reference
    {
    CInternetEmailDocument* self = new (ELeave) CInternetEmailDocument( aApp );
    CleanupStack::PushL( self );
    self->ConstructL();
    CleanupStack::Pop();
    return self;
    }
    
// ----------------------------------------------------
// CInternetEmailDocument::CreateAppUiL()
// constructs CInternetEmailAppUi
// ----------------------------------------------------
//
CEikAppUi* CInternetEmailDocument::CreateAppUiL()
    {
    return new (ELeave) CInternetEmailAppUi;
    }

// ----------------------------------------------------
// CInternetEmailDocument::OpenFileL
// Overrides CAknDocument::OpenFileL to support document file
// ----------------------------------------------------
//
CFileStore* CInternetEmailDocument::OpenFileL(TBool aDoOpen,const TDesC& aFilename,RFs& aFs)
    {
    return CEikDocument::OpenFileL(aDoOpen, aFilename, aFs);
    }

// End of File
