/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef AUDIOSTREAMAPP_H
#define AUDIOSTREAMAPP_H

// INCLUDES
#include <aknapp.h>

// CONSTANTS
// UID of the application
const TUid KUidAudioStream = { 0xE01FF1C3 };

// CLASS DECLARATION

/**
* CAudioStreamApp application class.
* Provides factory to create concrete document object.
* 
*/
class CAudioStreamApp : public CAknApplication
    {
    
    public: // Functions from base classes
    private:

        /**
        * From CApaApplication, creates CAudioStreamDocument document object.
        * return A pointer to the created document object.
        */
        CApaDocument* CreateDocumentL();
        
        /**
        * From CApaApplication, returns application's UID (KUidAudioStream).
        * return The value of KUidAudioStream.
        */
        TUid AppDllUid() const;
    };

#endif

// End of File

