/*
 * Copyright  2008 Nokia Corporation.
 */

#ifndef AUDIOSTREAMVIEW_H
#define AUDIOSTREAMVIEW_H

// INCLUDES
#include <coecntrl.h>
#include "AudioStreamEngine.h"
#include <eikrted.h>

// FORWARD DECLARATIONS
class CAudioStreamEngine;

// CLASS DECLARATION

/**
*  CAudioStreamView  container control class.
*  
*/
class CAudioStreamView : public CCoeControl
{
public: 

/*!
 * NewL()
 * 
 * discussion Create new CAudioStreamView object, being able to draw 
 *    itself into aRect
 *
 * param aRect the rectangle this view will be drawn to
 * param aEngine the engine which core logic is used by this simple view
 * return a pointer to the created instance of CAudioStreamView
 */
    static CAudioStreamView* NewL(const TRect& aRect, 
        CAudioStreamEngine* aEngine);

/*!
 * NewLC()
 * 
 * discussion Create new CAudioStreamView object, being able to draw
 *    itself into aRect
 *
 * param aRect the rectangle this view will be drawn to
 * return a pointer to the created instance of CAudioStreamView 
 *    which has also been pushed to cleanup stack
 */
    static CAudioStreamView* NewLC(const TRect& aRect, 
        CAudioStreamEngine* aEngine);


/*!
 * ~CAudioStreamView()
 *
 * discussion Destroy the object and release all memory objects
 */
    ~CAudioStreamView();
        
public: // New functions

/*!
 * ShowMessageL()
 *
 * discussion Displays application messages for user
 *
 * param aMsg text to be displayed
 */
    void ShowMessageL(const TDesC& /* aMsg */);

public: // Functions from base classes

private: // Basic two-phase EPOC constructors

/*!
 * ConstructL()
 *
 * discussion Perform the second phase construction of a CAudioStreamView
 *    object
 *
 * param aRect Frame rectangle for container.
 */
    void ConstructL(const TRect& aRect, CAudioStreamEngine* aEngine);
 
/*!
 * CAudioStreamView()
 *
 * discussion Perform the first phase of two phase construction 
 */
    CAudioStreamView();

private: // Functions from base classes

   /**
    * From CoeControl,SizeChanged.
    */
    void SizeChanged();

   /**
    * From CoeControl,HandleResourceChange.
    */
    void HandleResourceChange(TInt aType);

   /**
    * From CoeControl,CountComponentControls.
    */
    TInt CountComponentControls() const;

   /**
    * From CCoeControl,ComponentControl.
    */
    CCoeControl* ComponentControl(TInt aIndex) const;

   /**
    * From CCoeControl,Draw.
    */
    void Draw(const TRect& aRect) const;
    
private: // New functions
    
        
private: // data members

    // Reference for engine object
    CAudioStreamEngine* iEngine;        

    // Displaying the application messages to user
    CEikRichTextEditor* iLogComponent;
    
};

#endif

// End of File


