/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include    "AudioStreamApp.h"
#include    "AudioStreamDocument.h"

#include    <eikstart.h>


// ----------------------------------------------------------------------------
// CAudioStreamApp::AppDllUid()
//
// returns application UID
// ----------------------------------------------------------------------------
TUid CAudioStreamApp::AppDllUid() const
    {
    return KUidAudioStream;
    }

   
// ----------------------------------------------------------------------------
// CAudioStreamApp::CreateDocumentL()
//
// creates CAudioStreamDocument object
// ----------------------------------------------------------------------------
CApaDocument* CAudioStreamApp::CreateDocumentL()
    {
    return CAudioStreamDocument::NewL( *this );
    }


// ----------------------------------------------------------------------------
// NewApplication() 
//
// constructs CAudioStreamApp
// ----------------------------------------------------------------------------
EXPORT_C CApaApplication* NewApplication()
    {
    return new CAudioStreamApp;
    }

// ---------------------------------------------------------
// Entry point function for Symbian Apps, separate function for
// S60 3rd Ed and 1st/2nd Ed
// ---------------------------------------------------------
//
GLDEF_C TInt E32Main()
    {
    return EikStart::RunApplication( NewApplication );
    }

// End of File  

