/*
 * Copyright  2008 Nokia Corporation.
 */

// INCLUDE FILES
#include "AudioStreamDocument.h"
#include "AudioStreamAppUi.h"


CAudioStreamDocument* CAudioStreamDocument::NewL(
        CEikApplication& aApp)     // CAudioStreamApp reference
    {
    CAudioStreamDocument* self = new (ELeave) CAudioStreamDocument( aApp );
    CleanupStack::PushL( self );
    self->ConstructL();
    CleanupStack::Pop(self);
    return self;
    }

// ----------------------------------------------------------------------------
// CAudioStreamDocument::CAudioStreamDocument(CEikApplication& aApp)
//
// constructor
// ----------------------------------------------------------------------------
CAudioStreamDocument::CAudioStreamDocument(CEikApplication& aApp):
    CAknDocument(aApp)    
    {
    }

// ----------------------------------------------------------------------------
// CAudioStreamDocument::~CAudioStreamDocument()
//
// destructor
// ----------------------------------------------------------------------------
CAudioStreamDocument::~CAudioStreamDocument()
    {
    }

// ----------------------------------------------------------------------------
// CAudioStreamDocument::ConstructL()
//
// Standard EPOC 2nd phase constructor
// ----------------------------------------------------------------------------
void CAudioStreamDocument::ConstructL()
    {
    }

    
// ----------------------------------------------------------------------------
// CAudioStreamDocument::CreateAppUiL()
// constructs CAudioStreamAppUi
// ----------------------------------------------------------------------------
CEikAppUi* CAudioStreamDocument::CreateAppUiL()
    {
    return new (ELeave) CAudioStreamAppUi;
    }

// End of File  

